/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import com.facebook.drawee.controller.AbstractDraweeController;
import com.facebook.drawee.controller.AbstractDraweeControllerBuilder;
import com.facebook.drawee.controller.ControllerListener;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.generic.GenericDraweeHierarchyBuilder;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.drawee.interfaces.DraweeHierarchy;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.flat.FlatViewGroup;
import com.facebook.react.flat.RCTImageView;
import javax.annotation.Nullable;

final class DraweeRequestHelper {
    private static GenericDraweeHierarchyBuilder sHierarchyBuilder;
    private static AbstractDraweeControllerBuilder sControllerBuilder;
    private final DraweeController mDraweeController;
    private int mAttachCounter;

    static void setResources(Resources resources) {
        sHierarchyBuilder = new GenericDraweeHierarchyBuilder(resources);
    }

    static void setDraweeControllerBuilder(AbstractDraweeControllerBuilder builder) {
        sControllerBuilder = builder;
    }

    DraweeRequestHelper(ImageRequest imageRequest, @Nullable ImageRequest cachedImageRequest, ControllerListener listener) {
        AbstractDraweeControllerBuilder controllerBuilder = sControllerBuilder.setImageRequest((Object)imageRequest).setCallerContext(RCTImageView.getCallerContext()).setControllerListener(listener);
        if (cachedImageRequest != null) {
            controllerBuilder.setLowResImageRequest((Object)cachedImageRequest);
        }
        AbstractDraweeController controller = controllerBuilder.build();
        controller.setHierarchy((DraweeHierarchy)sHierarchyBuilder.build());
        this.mDraweeController = controller;
    }

    void attach(FlatViewGroup.InvalidateCallback callback) {
        ++this.mAttachCounter;
        if (this.mAttachCounter == 1) {
            this.getDrawable().setCallback((Drawable.Callback)callback.get());
            this.mDraweeController.onAttach();
        }
    }

    void detach() {
        --this.mAttachCounter;
        if (this.mAttachCounter == 0) {
            this.mDraweeController.onDetach();
        }
    }

    GenericDraweeHierarchy getHierarchy() {
        return (GenericDraweeHierarchy)Assertions.assumeNotNull((Object)this.mDraweeController.getHierarchy());
    }

    Drawable getDrawable() {
        return this.getHierarchy().getTopLevelDrawable();
    }
}

