/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.content.Context;
import com.facebook.react.devsupport.DisabledDevSupportManager;
import com.facebook.react.devsupport.ReactInstanceManagerDevHelper;
import com.facebook.react.devsupport.RedBoxHandler;
import com.facebook.react.devsupport.interfaces.DevBundleDownloadListener;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import java.lang.reflect.Constructor;
import javax.annotation.Nullable;

public class DevSupportManagerFactory {
    private static final String DEVSUPPORT_IMPL_PACKAGE = "com.facebook.react.devsupport";
    private static final String DEVSUPPORT_IMPL_CLASS = "DevSupportManagerImpl";

    public static DevSupportManager create(Context applicationContext, ReactInstanceManagerDevHelper reactInstanceManagerHelper, @Nullable String packagerPathForJSBundleName, boolean enableOnCreate, int minNumShakes) {
        return DevSupportManagerFactory.create(applicationContext, reactInstanceManagerHelper, packagerPathForJSBundleName, enableOnCreate, null, null, minNumShakes);
    }

    public static DevSupportManager create(Context applicationContext, ReactInstanceManagerDevHelper reactInstanceManagerHelper, @Nullable String packagerPathForJSBundleName, boolean enableOnCreate, @Nullable RedBoxHandler redBoxHandler, @Nullable DevBundleDownloadListener devBundleDownloadListener, int minNumShakes) {
        if (!enableOnCreate) {
            return new DisabledDevSupportManager();
        }
        try {
            String className = DEVSUPPORT_IMPL_PACKAGE + "." + DEVSUPPORT_IMPL_CLASS;
            Class<?> devSupportManagerClass = Class.forName(className);
            Constructor<?> constructor = devSupportManagerClass.getConstructor(Context.class, ReactInstanceManagerDevHelper.class, String.class, Boolean.TYPE, RedBoxHandler.class, DevBundleDownloadListener.class, Integer.TYPE);
            return (DevSupportManager)constructor.newInstance(applicationContext, reactInstanceManagerHelper, packagerPathForJSBundleName, true, redBoxHandler, devBundleDownloadListener, minNumShakes);
        }
        catch (Exception e) {
            throw new RuntimeException("Requested enabled DevSupportManager, but DevSupportManagerImpl class was not found or could not be created", e);
        }
    }
}

