/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import android.graphics.Bitmap;
import com.facebook.common.executors.UiThreadImmediateExecutorService;
import com.facebook.common.references.CloseableReference;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSubscriber;
import com.facebook.imagepipeline.core.ImagePipeline;
import com.facebook.imagepipeline.core.ImagePipelineFactory;
import com.facebook.imagepipeline.image.CloseableBitmap;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.flat.BitmapUpdateListener;
import com.facebook.react.flat.RCTImageView;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

final class PipelineRequestHelper
implements DataSubscriber<CloseableReference<CloseableImage>> {
    private final ImageRequest mImageRequest;
    @Nullable
    private BitmapUpdateListener mBitmapUpdateListener;
    @Nullable
    private DataSource<CloseableReference<CloseableImage>> mDataSource;
    @Nullable
    private CloseableReference<CloseableImage> mImageRef;
    private int mAttachCounter;

    PipelineRequestHelper(ImageRequest imageRequest) {
        this.mImageRequest = imageRequest;
    }

    void attach(BitmapUpdateListener listener) {
        this.mBitmapUpdateListener = listener;
        ++this.mAttachCounter;
        if (this.mAttachCounter != 1) {
            Bitmap bitmap = this.getBitmap();
            if (bitmap != null) {
                listener.onSecondaryAttach(bitmap);
            }
            return;
        }
        listener.onImageLoadEvent(4);
        Assertions.assertCondition((this.mDataSource == null ? 1 : 0) != 0);
        Assertions.assertCondition((this.mImageRef == null ? 1 : 0) != 0);
        ImagePipeline imagePipeline = ImagePipelineFactory.getInstance().getImagePipeline();
        this.mDataSource = imagePipeline.fetchDecodedImage(this.mImageRequest, RCTImageView.getCallerContext());
        this.mDataSource.subscribe((DataSubscriber)this, (Executor)UiThreadImmediateExecutorService.getInstance());
    }

    void detach() {
        --this.mAttachCounter;
        if (this.mAttachCounter != 0) {
            return;
        }
        if (this.mDataSource != null) {
            this.mDataSource.close();
            this.mDataSource = null;
        }
        if (this.mImageRef != null) {
            this.mImageRef.close();
            this.mImageRef = null;
        }
        this.mBitmapUpdateListener = null;
    }

    @Nullable
    Bitmap getBitmap() {
        if (this.mImageRef == null) {
            return null;
        }
        CloseableImage closeableImage = (CloseableImage)this.mImageRef.get();
        if (!(closeableImage instanceof CloseableBitmap)) {
            this.mImageRef.close();
            this.mImageRef = null;
            return null;
        }
        return ((CloseableBitmap)closeableImage).getUnderlyingBitmap();
    }

    boolean isDetached() {
        return this.mAttachCounter == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNewResult(DataSource<CloseableReference<CloseableImage>> dataSource) {
        if (!dataSource.isFinished()) {
            return;
        }
        try {
            if (this.mDataSource != dataSource) {
                return;
            }
            this.mDataSource = null;
            CloseableReference imageReference = (CloseableReference)dataSource.getResult();
            if (imageReference == null) {
                return;
            }
            CloseableImage image = (CloseableImage)imageReference.get();
            if (!(image instanceof CloseableBitmap)) {
                imageReference.close();
                return;
            }
            this.mImageRef = imageReference;
            Bitmap bitmap = this.getBitmap();
            if (bitmap == null) {
                return;
            }
            BitmapUpdateListener listener = (BitmapUpdateListener)Assertions.assumeNotNull((Object)this.mBitmapUpdateListener);
            listener.onBitmapReady(bitmap);
            listener.onImageLoadEvent(2);
            listener.onImageLoadEvent(3);
        }
        finally {
            dataSource.close();
        }
    }

    public void onFailure(DataSource<CloseableReference<CloseableImage>> dataSource) {
        if (this.mDataSource == dataSource) {
            ((BitmapUpdateListener)Assertions.assumeNotNull((Object)this.mBitmapUpdateListener)).onImageLoadEvent(1);
            ((BitmapUpdateListener)Assertions.assumeNotNull((Object)this.mBitmapUpdateListener)).onImageLoadEvent(3);
            this.mDataSource = null;
        }
        dataSource.close();
    }

    public void onCancellation(DataSource<CloseableReference<CloseableImage>> dataSource) {
        if (this.mDataSource == dataSource) {
            this.mDataSource = null;
        }
        dataSource.close();
    }

    public void onProgressUpdate(DataSource<CloseableReference<CloseableImage>> dataSource) {
    }
}

