/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.common.memory;

import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.memory.ByteArrayPool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PooledByteStreams {
    private static final int DEFAULT_TEMP_BUF_SIZE = 16384;
    private final int mTempBufSize;
    private final ByteArrayPool mByteArrayPool;

    public PooledByteStreams(ByteArrayPool byteArrayPool) {
        this(byteArrayPool, 16384);
    }

    @VisibleForTesting
    public PooledByteStreams(ByteArrayPool byteArrayPool, int tempBufSize) {
        Preconditions.checkArgument(tempBufSize > 0);
        this.mTempBufSize = tempBufSize;
        this.mByteArrayPool = byteArrayPool;
    }

    public long copy(InputStream from, OutputStream to) throws IOException {
        long count = 0L;
        byte[] tmp = (byte[])this.mByteArrayPool.get(this.mTempBufSize);
        try {
            while (true) {
                int read;
                if ((read = from.read(tmp, 0, this.mTempBufSize)) == -1) {
                    long l = count;
                    return l;
                }
                to.write(tmp, 0, read);
                count += (long)read;
            }
        }
        finally {
            this.mByteArrayPool.release(tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copy(InputStream from, OutputStream to, long bytesToCopy) throws IOException {
        Preconditions.checkState(bytesToCopy > 0L);
        byte[] tmp = (byte[])this.mByteArrayPool.get(this.mTempBufSize);
        try {
            long copied;
            int read;
            for (copied = 0L; copied < bytesToCopy; copied += (long)read) {
                read = from.read(tmp, 0, (int)Math.min((long)this.mTempBufSize, bytesToCopy - copied));
                if (read == -1) {
                    long l = copied;
                    return l;
                }
                to.write(tmp, 0, read);
            }
            long l = copied;
            return l;
        }
        finally {
            this.mByteArrayPool.release(tmp);
        }
    }
}

