/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.intent;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.net.Uri;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.module.annotations.ReactModule;

@ReactModule(name="IntentAndroid")
public class IntentModule
extends ReactContextBaseJavaModule {
    public IntentModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    public String getName() {
        return "IntentAndroid";
    }

    @ReactMethod
    public void getInitialURL(Promise promise) {
        try {
            Activity currentActivity = this.getCurrentActivity();
            String initialURL = null;
            if (currentActivity != null) {
                Intent intent = currentActivity.getIntent();
                String action = intent.getAction();
                Uri uri = intent.getData();
                if ("android.intent.action.VIEW".equals(action) && uri != null) {
                    initialURL = uri.toString();
                }
            }
            promise.resolve(initialURL);
        }
        catch (Exception e) {
            promise.reject(new JSApplicationIllegalArgumentException("Could not get the initial URL : " + e.getMessage()));
        }
    }

    @ReactMethod
    public void openURL(String url, Promise promise) {
        if (url == null || url.isEmpty()) {
            promise.reject(new JSApplicationIllegalArgumentException("Invalid URL: " + url));
            return;
        }
        try {
            String otherPackageName;
            Activity currentActivity = this.getCurrentActivity();
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            String selfPackageName = this.getReactApplicationContext().getPackageName();
            ComponentName componentName = intent.resolveActivity(this.getReactApplicationContext().getPackageManager());
            String string = otherPackageName = componentName != null ? componentName.getPackageName() : "";
            if (currentActivity == null || !selfPackageName.equals(otherPackageName)) {
                intent.addFlags(0x10000000);
            }
            if (currentActivity != null) {
                currentActivity.startActivity(intent);
            } else {
                this.getReactApplicationContext().startActivity(intent);
            }
            promise.resolve(true);
        }
        catch (Exception e) {
            promise.reject(new JSApplicationIllegalArgumentException("Could not open URL '" + url + "': " + e.getMessage()));
        }
    }

    @ReactMethod
    public void canOpenURL(String url, Promise promise) {
        if (url == null || url.isEmpty()) {
            promise.reject(new JSApplicationIllegalArgumentException("Invalid URL: " + url));
            return;
        }
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            intent.addFlags(0x10000000);
            boolean canOpen = intent.resolveActivity(this.getReactApplicationContext().getPackageManager()) != null;
            promise.resolve(canOpen);
        }
        catch (Exception e) {
            promise.reject(new JSApplicationIllegalArgumentException("Could not check if URL '" + url + "' can be opened: " + e.getMessage()));
        }
    }
}

