/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import android.content.Context;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.flat.AbstractDrawCommand;
import com.facebook.react.flat.AttachDetachListener;
import com.facebook.react.flat.DrawImage;
import com.facebook.react.flat.FlatShadowNode;
import com.facebook.react.flat.StateBuilder;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.image.ImageResizeMode;
import javax.annotation.Nullable;

class RCTImageView<T extends AbstractDrawCommand>
extends FlatShadowNode {
    static Object sCallerContext = RCTImageView.class;
    private T mDrawImage;

    static void setCallerContext(Object callerContext) {
        sCallerContext = callerContext;
    }

    static Object getCallerContext() {
        return sCallerContext;
    }

    RCTImageView(T drawImage) {
        this.mDrawImage = drawImage;
    }

    @Override
    protected void collectState(StateBuilder stateBuilder, float left, float top, float right, float bottom, float clipLeft, float clipTop, float clipRight, float clipBottom) {
        super.collectState(stateBuilder, left, top, right, bottom, clipLeft, clipTop, clipRight, clipBottom);
        if (((DrawImage)this.mDrawImage).hasImageRequest()) {
            this.mDrawImage = ((AbstractDrawCommand)this.mDrawImage).updateBoundsAndFreeze(left, top, right, bottom, clipLeft, clipTop, clipRight, clipBottom);
            stateBuilder.addDrawCommand((AbstractDrawCommand)this.mDrawImage);
            stateBuilder.addAttachDetachListener((AttachDetachListener)this.mDrawImage);
        }
    }

    @Override
    boolean doesDraw() {
        return ((DrawImage)this.mDrawImage).hasImageRequest() || super.doesDraw();
    }

    @ReactProp(name="shouldNotifyLoadEvents")
    public void setShouldNotifyLoadEvents(boolean shouldNotifyLoadEvents) {
        ((DrawImage)this.getMutableDrawImage()).setReactTag(shouldNotifyLoadEvents ? this.getReactTag() : 0);
    }

    @ReactProp(name="src")
    public void setSource(@Nullable ReadableArray sources) {
        ((DrawImage)this.getMutableDrawImage()).setSource((Context)this.getThemedContext(), sources);
    }

    @ReactProp(name="tintColor")
    public void setTintColor(int tintColor) {
        ((DrawImage)this.getMutableDrawImage()).setTintColor(tintColor);
    }

    @ReactProp(name="resizeMode")
    public void setResizeMode(@Nullable String resizeMode) {
        ScalingUtils.ScaleType scaleType = ImageResizeMode.toScaleType(resizeMode);
        if (((DrawImage)this.mDrawImage).getScaleType() != scaleType) {
            ((DrawImage)this.getMutableDrawImage()).setScaleType(scaleType);
        }
    }

    @ReactProp(name="borderColor", customType="Color")
    public void setBorderColor(int borderColor) {
        if (((DrawImage)this.mDrawImage).getBorderColor() != borderColor) {
            ((DrawImage)this.getMutableDrawImage()).setBorderColor(borderColor);
        }
    }

    @Override
    public void setBorder(int spacingType, float borderWidth) {
        super.setBorder(spacingType, borderWidth);
        if (spacingType == 8 && ((DrawImage)this.mDrawImage).getBorderWidth() != borderWidth) {
            ((DrawImage)this.getMutableDrawImage()).setBorderWidth(borderWidth);
        }
    }

    @ReactProp(name="borderRadius")
    public void setBorderRadius(float borderRadius) {
        if (((DrawImage)this.mDrawImage).getBorderRadius() != borderRadius) {
            ((DrawImage)this.getMutableDrawImage()).setBorderRadius(PixelUtil.toPixelFromDIP(borderRadius));
        }
    }

    @ReactProp(name="fadeDuration")
    public void setFadeDuration(int durationMs) {
        ((DrawImage)this.getMutableDrawImage()).setFadeDuration(durationMs);
    }

    @ReactProp(name="progressiveRenderingEnabled")
    public void setProgressiveRenderingEnabled(boolean enabled) {
        ((DrawImage)this.getMutableDrawImage()).setProgressiveRenderingEnabled(enabled);
    }

    private T getMutableDrawImage() {
        if (((AbstractDrawCommand)this.mDrawImage).isFrozen()) {
            this.mDrawImage = ((AbstractDrawCommand)this.mDrawImage).mutableCopy();
            this.invalidate();
        }
        return this.mDrawImage;
    }
}

