/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import com.facebook.react.flat.AbstractDrawCommand;
import com.facebook.react.flat.FlatViewGroup;
import javax.annotation.Nullable;

final class DrawView
extends AbstractDrawCommand {
    public static final DrawView[] EMPTY_ARRAY = new DrawView[0];
    static final float MINIMUM_ROUNDED_CLIPPING_VALUE = 0.5f;
    private final RectF TMP_RECT = new RectF();
    final int reactTag;
    boolean mWasMounted;
    private float mClipRadius;
    @Nullable
    private Path mPath;
    float mLogicalLeft;
    float mLogicalTop;
    float mLogicalRight;
    float mLogicalBottom;

    public DrawView(int reactTag) {
        this.reactTag = reactTag;
    }

    public DrawView collectDrawView(float left, float top, float right, float bottom, float logicalLeft, float logicalTop, float logicalRight, float logicalBottom, float clipLeft, float clipTop, float clipRight, float clipBottom, float clipRadius) {
        if (!this.isFrozen()) {
            this.setBounds(left, top, right, bottom);
            this.setClipBounds(clipLeft, clipTop, clipRight, clipBottom);
            this.setClipRadius(clipRadius);
            this.setLogicalBounds(logicalLeft, logicalTop, logicalRight, logicalBottom);
            this.freeze();
            return this;
        }
        boolean boundsMatch = this.boundsMatch(left, top, right, bottom);
        boolean clipBoundsMatch = this.clipBoundsMatch(clipLeft, clipTop, clipRight, clipBottom);
        boolean clipRadiusMatch = this.mClipRadius == clipRadius;
        boolean logicalBoundsMatch = this.logicalBoundsMatch(logicalLeft, logicalTop, logicalRight, logicalBottom);
        if (boundsMatch && clipBoundsMatch && clipRadiusMatch && logicalBoundsMatch) {
            return this;
        }
        DrawView drawView = (DrawView)this.mutableCopy();
        if (!boundsMatch) {
            drawView.setBounds(left, top, right, bottom);
        }
        if (!clipBoundsMatch) {
            drawView.setClipBounds(clipLeft, clipTop, clipRight, clipBottom);
        }
        if (!logicalBoundsMatch) {
            drawView.setLogicalBounds(logicalLeft, logicalTop, logicalRight, logicalBottom);
        }
        if (!clipRadiusMatch || !boundsMatch) {
            drawView.setClipRadius(clipRadius);
        }
        drawView.mWasMounted = false;
        drawView.freeze();
        return drawView;
    }

    private boolean logicalBoundsMatch(float left, float top, float right, float bottom) {
        return left == this.mLogicalLeft && top == this.mLogicalTop && right == this.mLogicalRight && bottom == this.mLogicalBottom;
    }

    private void setLogicalBounds(float left, float top, float right, float bottom) {
        this.mLogicalLeft = left;
        this.mLogicalTop = top;
        this.mLogicalRight = right;
        this.mLogicalBottom = bottom;
    }

    @Override
    public void draw(FlatViewGroup parent, Canvas canvas) {
        this.onPreDraw(parent, canvas);
        if (this.mNeedsClipping || this.mClipRadius > 0.5f) {
            canvas.save(2);
            this.applyClipping(canvas);
            parent.drawNextChild(canvas);
            canvas.restore();
        } else {
            parent.drawNextChild(canvas);
        }
    }

    void setClipRadius(float clipRadius) {
        this.mClipRadius = clipRadius;
        if (clipRadius > 0.5f) {
            this.updateClipPath();
        } else {
            this.mPath = null;
        }
    }

    private void updateClipPath() {
        this.mPath = new Path();
        this.TMP_RECT.set(this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
        this.mPath.addRoundRect(this.TMP_RECT, this.mClipRadius, this.mClipRadius, Path.Direction.CW);
    }

    @Override
    protected void applyClipping(Canvas canvas) {
        if (this.mClipRadius > 0.5f) {
            canvas.clipPath(this.mPath);
        } else {
            super.applyClipping(canvas);
        }
    }

    @Override
    protected void onDraw(Canvas canvas) {
    }

    @Override
    protected void onDebugDraw(FlatViewGroup parent, Canvas canvas) {
        parent.debugDrawNextChild(canvas);
    }

    @Override
    protected void onDebugDrawHighlight(Canvas canvas) {
        if (this.mPath != null) {
            this.debugDrawWarningHighlight(canvas, "borderRadius: " + this.mClipRadius);
        } else if (!this.boundsMatch(this.mLogicalLeft, this.mLogicalTop, this.mLogicalRight, this.mLogicalBottom)) {
            StringBuilder warn = new StringBuilder("Overflow: { ");
            String[] names = new String[]{"left: ", "top: ", "right: ", "bottom: "};
            int i = 0;
            float[] offsets = new float[4];
            offsets[i++] = this.getLeft() - this.mLogicalLeft;
            offsets[i++] = this.getTop() - this.mLogicalTop;
            offsets[i++] = this.mLogicalRight - this.getRight();
            offsets[i++] = this.mLogicalBottom - this.getBottom();
            for (i = 0; i < 4; ++i) {
                if (offsets[i] == 0.0f) continue;
                warn.append(names[i]);
                warn.append(offsets[i]);
                warn.append(", ");
            }
            warn.append("}");
            this.debugDrawCautionHighlight(canvas, warn.toString());
        }
    }
}

