/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.graphics.Bitmap;
import android.media.ThumbnailUtils;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.imagepipeline.bitmaps.SimpleBitmapReleaser;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.CloseableStaticBitmap;
import com.facebook.imagepipeline.image.ImmutableQualityInfo;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener;
import com.facebook.imagepipeline.producers.StatefulProducerRunnable;
import com.facebook.imagepipeline.request.ImageRequest;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.Executor;

public class LocalVideoThumbnailProducer
implements Producer<CloseableReference<CloseableImage>> {
    public static final String PRODUCER_NAME = "VideoThumbnailProducer";
    @VisibleForTesting
    static final String CREATED_THUMBNAIL = "createdThumbnail";
    private final Executor mExecutor;

    public LocalVideoThumbnailProducer(Executor executor) {
        this.mExecutor = executor;
    }

    @Override
    public void produceResults(Consumer<CloseableReference<CloseableImage>> consumer, ProducerContext producerContext) {
        final ProducerListener listener = producerContext.getListener();
        final String requestId = producerContext.getId();
        final ImageRequest imageRequest = producerContext.getImageRequest();
        final StatefulProducerRunnable<CloseableReference<CloseableImage>> cancellableProducerRunnable = new StatefulProducerRunnable<CloseableReference<CloseableImage>>(consumer, listener, PRODUCER_NAME, requestId){

            @Override
            protected void onSuccess(CloseableReference<CloseableImage> result) {
                super.onSuccess(result);
                listener.onUltimateProducerReached(requestId, LocalVideoThumbnailProducer.PRODUCER_NAME, result != null);
            }

            @Override
            protected void onFailure(Exception e) {
                super.onFailure(e);
                listener.onUltimateProducerReached(requestId, LocalVideoThumbnailProducer.PRODUCER_NAME, false);
            }

            protected CloseableReference<CloseableImage> getResult() throws Exception {
                Bitmap thumbnailBitmap = ThumbnailUtils.createVideoThumbnail((String)imageRequest.getSourceFile().getPath(), (int)LocalVideoThumbnailProducer.calculateKind(imageRequest));
                if (thumbnailBitmap == null) {
                    return null;
                }
                return CloseableReference.of((Closeable)new CloseableStaticBitmap(thumbnailBitmap, (ResourceReleaser)SimpleBitmapReleaser.getInstance(), ImmutableQualityInfo.FULL_QUALITY, 0));
            }

            @Override
            protected Map<String, String> getExtraMapOnSuccess(CloseableReference<CloseableImage> result) {
                return ImmutableMap.of((Object)LocalVideoThumbnailProducer.CREATED_THUMBNAIL, (Object)String.valueOf(result != null));
            }

            @Override
            protected void disposeResult(CloseableReference<CloseableImage> result) {
                CloseableReference.closeSafely(result);
            }
        };
        producerContext.addCallbacks(new BaseProducerContextCallbacks(){

            @Override
            public void onCancellationRequested() {
                cancellableProducerRunnable.cancel();
            }
        });
        this.mExecutor.execute((Runnable)((Object)cancellableProducerRunnable));
    }

    private static int calculateKind(ImageRequest imageRequest) {
        if (imageRequest.getPreferredWidth() > 96 || imageRequest.getPreferredHeight() > 96) {
            return 1;
        }
        return 3;
    }
}

