/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.memory.PooledByteBufferFactory;
import com.facebook.common.memory.PooledByteStreams;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.imagepipeline.memory.NativeMemoryChunk;
import com.facebook.imagepipeline.memory.NativeMemoryChunkPool;
import com.facebook.imagepipeline.memory.NativePooledByteBuffer;
import com.facebook.imagepipeline.memory.NativePooledByteBufferOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class NativePooledByteBufferFactory
implements PooledByteBufferFactory {
    private final PooledByteStreams mPooledByteStreams;
    private final NativeMemoryChunkPool mPool;

    public NativePooledByteBufferFactory(NativeMemoryChunkPool pool, PooledByteStreams pooledByteStreams) {
        this.mPool = pool;
        this.mPooledByteStreams = pooledByteStreams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NativePooledByteBuffer newByteBuffer(int size) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0);
        try (CloseableReference chunkRef = CloseableReference.of(this.mPool.get(size), (ResourceReleaser)this.mPool);){
            NativePooledByteBuffer nativePooledByteBuffer = new NativePooledByteBuffer((CloseableReference<NativeMemoryChunk>)chunkRef, size);
            return nativePooledByteBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NativePooledByteBuffer newByteBuffer(InputStream inputStream) throws IOException {
        try (NativePooledByteBufferOutputStream outputStream = new NativePooledByteBufferOutputStream(this.mPool);){
            NativePooledByteBuffer nativePooledByteBuffer = this.newByteBuf(inputStream, outputStream);
            return nativePooledByteBuffer;
        }
    }

    public NativePooledByteBuffer newByteBuffer(byte[] bytes) {
        try (NativePooledByteBufferOutputStream outputStream = new NativePooledByteBufferOutputStream(this.mPool, bytes.length);){
            outputStream.write(bytes, 0, bytes.length);
            NativePooledByteBuffer nativePooledByteBuffer = outputStream.toByteBuffer();
            return nativePooledByteBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NativePooledByteBuffer newByteBuffer(InputStream inputStream, int initialCapacity) throws IOException {
        try (NativePooledByteBufferOutputStream outputStream = new NativePooledByteBufferOutputStream(this.mPool, initialCapacity);){
            NativePooledByteBuffer nativePooledByteBuffer = this.newByteBuf(inputStream, outputStream);
            return nativePooledByteBuffer;
        }
    }

    @VisibleForTesting
    NativePooledByteBuffer newByteBuf(InputStream inputStream, NativePooledByteBufferOutputStream outputStream) throws IOException {
        this.mPooledByteStreams.copy(inputStream, (OutputStream)((Object)outputStream));
        return outputStream.toByteBuffer();
    }

    public NativePooledByteBufferOutputStream newOutputStream() {
        return new NativePooledByteBufferOutputStream(this.mPool);
    }

    public NativePooledByteBufferOutputStream newOutputStream(int initialCapacity) {
        return new NativePooledByteBufferOutputStream(this.mPool, initialCapacity);
    }
}

