/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.cache.common.CacheKey;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.memory.PooledByteBuffer;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.cache.CacheKeyFactory;
import com.facebook.imagepipeline.cache.MemoryCache;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener;
import com.facebook.imagepipeline.request.ImageRequest;

public class EncodedMemoryCacheProducer
implements Producer<EncodedImage> {
    public static final String PRODUCER_NAME = "EncodedMemoryCacheProducer";
    public static final String EXTRA_CACHED_VALUE_FOUND = "cached_value_found";
    private final MemoryCache<CacheKey, PooledByteBuffer> mMemoryCache;
    private final CacheKeyFactory mCacheKeyFactory;
    private final Producer<EncodedImage> mInputProducer;

    public EncodedMemoryCacheProducer(MemoryCache<CacheKey, PooledByteBuffer> memoryCache, CacheKeyFactory cacheKeyFactory, Producer<EncodedImage> inputProducer) {
        this.mMemoryCache = memoryCache;
        this.mCacheKeyFactory = cacheKeyFactory;
        this.mInputProducer = inputProducer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void produceResults(Consumer<EncodedImage> consumer, ProducerContext producerContext) {
        String requestId = producerContext.getId();
        ProducerListener listener = producerContext.getListener();
        listener.onProducerStart(requestId, PRODUCER_NAME);
        ImageRequest imageRequest = producerContext.getImageRequest();
        CacheKey cacheKey = this.mCacheKeyFactory.getEncodedCacheKey(imageRequest, producerContext.getCallerContext());
        CloseableReference cachedReference = this.mMemoryCache.get((Object)cacheKey);
        try {
            if (cachedReference != null) {
                EncodedImage cachedEncodedImage = new EncodedImage(cachedReference);
                cachedEncodedImage.setEncodedCacheKey(cacheKey);
                try {
                    listener.onProducerFinishWithSuccess(requestId, PRODUCER_NAME, listener.requiresExtraMap(requestId) ? ImmutableMap.of((Object)EXTRA_CACHED_VALUE_FOUND, (Object)"true") : null);
                    listener.onUltimateProducerReached(requestId, PRODUCER_NAME, true);
                    consumer.onProgressUpdate(1.0f);
                    consumer.onNewResult(cachedEncodedImage, true);
                    return;
                }
                finally {
                    EncodedImage.closeSafely((EncodedImage)cachedEncodedImage);
                }
            }
            if (producerContext.getLowestPermittedRequestLevel().getValue() >= ImageRequest.RequestLevel.ENCODED_MEMORY_CACHE.getValue()) {
                listener.onProducerFinishWithSuccess(requestId, PRODUCER_NAME, listener.requiresExtraMap(requestId) ? ImmutableMap.of((Object)EXTRA_CACHED_VALUE_FOUND, (Object)"false") : null);
                listener.onUltimateProducerReached(requestId, PRODUCER_NAME, false);
                consumer.onNewResult(null, true);
                return;
            }
            EncodedMemoryCacheConsumer consumerOfInputProducer = new EncodedMemoryCacheConsumer(consumer, this.mMemoryCache, cacheKey);
            listener.onProducerFinishWithSuccess(requestId, PRODUCER_NAME, listener.requiresExtraMap(requestId) ? ImmutableMap.of((Object)EXTRA_CACHED_VALUE_FOUND, (Object)"false") : null);
            this.mInputProducer.produceResults(consumerOfInputProducer, producerContext);
            return;
        }
        finally {
            CloseableReference.closeSafely((CloseableReference)cachedReference);
        }
    }

    private static class EncodedMemoryCacheConsumer
    extends DelegatingConsumer<EncodedImage, EncodedImage> {
        private final MemoryCache<CacheKey, PooledByteBuffer> mMemoryCache;
        private final CacheKey mRequestedCacheKey;

        public EncodedMemoryCacheConsumer(Consumer<EncodedImage> consumer, MemoryCache<CacheKey, PooledByteBuffer> memoryCache, CacheKey requestedCacheKey) {
            super(consumer);
            this.mMemoryCache = memoryCache;
            this.mRequestedCacheKey = requestedCacheKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNewResultImpl(EncodedImage newResult, boolean isLast) {
            if (!isLast || newResult == null) {
                this.getConsumer().onNewResult(newResult, isLast);
                return;
            }
            CloseableReference ref = newResult.getByteBufferRef();
            if (ref != null) {
                CloseableReference cachedResult;
                try {
                    CacheKey cacheKey = newResult.getEncodedCacheKey() != null ? newResult.getEncodedCacheKey() : this.mRequestedCacheKey;
                    cachedResult = this.mMemoryCache.cache((Object)cacheKey, ref);
                }
                finally {
                    CloseableReference.closeSafely((CloseableReference)ref);
                }
                if (cachedResult != null) {
                    EncodedImage cachedEncodedImage;
                    try {
                        cachedEncodedImage = new EncodedImage(cachedResult);
                        cachedEncodedImage.copyMetaDataFrom(newResult);
                    }
                    finally {
                        CloseableReference.closeSafely((CloseableReference)cachedResult);
                    }
                    try {
                        this.getConsumer().onProgressUpdate(1.0f);
                        this.getConsumer().onNewResult(cachedEncodedImage, true);
                        return;
                    }
                    finally {
                        EncodedImage.closeSafely((EncodedImage)cachedEncodedImage);
                    }
                }
            }
            this.getConsumer().onNewResult(newResult, true);
        }
    }
}

