using Packt.CloudySkiesAir.Chapter7;

namespace Chapter7Tests; 

public class MileageTrackerTests {
    [Fact]
    public void NewAccountShouldHaveStartingBalance() {
        // Organizacja
        int expectedMiles = 100;

        // Dziaanie
        MileageTracker tracker = new();

        // Asercja
        Assert.Equal(expectedMiles, tracker.Balance);
    }

    [Fact]
    public void AddMileageShouldIncreaseBalance() {
        // Organizacja
        MileageTracker tracker = new();

        // Dziaanie
        tracker.AddMiles(50);

        // Asercja
        Assert.Equal(150, tracker.Balance);
    }

    [Fact]
    public void RedeemMileageShouldDecreaseBalance() {
        // Organizacja
        MileageTracker tracker = new();
        tracker.AddMiles(900);

        // Dziaanie
        tracker.RedeemMiles(250);

        // Asercja
        Assert.Equal(750, tracker.Balance);
    }

    [Fact]
    public void RedeemMileageShouldPreventNegativeBalance() {
        // Organizacja
        MileageTracker tracker = new();
        int startingBalance = tracker.Balance;

        // Dziaanie
        tracker.RedeemMiles(2500);

        // Asercja
        Assert.Equal(startingBalance, tracker.Balance);
    }

    [Theory]
    [InlineData(900, 250, 750)]
    [InlineData(0, 2500, 100)]
    public void RedeemMileageShouldResultInCorrectBalance(int addAmount, int redeemAmount, int expectedBalance) {
        // Organizacja
        MileageTracker tracker = new();
        tracker.AddMiles(addAmount);

        // Dziaanie
        tracker.RedeemMiles(redeemAmount);

        // Asercja
        Assert.Equal(expectedBalance, tracker.Balance);
    }
}