# Rozdział 8. Wykorzystywanie danych

Dane stanowią siłę napędową aplikacji. Niczym woda odżywiają komponenty odpowiednimi wartościami. Komponenty interfejsu użytkownika, które dotychczas tworzyliśmy, są swego rodzaju naczyniami dla danych. Aplikacje wypełniamy danymi pochodzącymi z internetu. Zbieramy, tworzymy i wysyłamy nowe dane do internetu. Wartością aplikacji nie są same komponenty, lecz przepływające przez nie dane.

## Przykłady

### Żądanie danych

1. fetch() ([uruchom](https://codesandbox.io/s/dry-sea-wmw8w?file=/src/index.js))
2. requestGithubUser ([uruchom](https://codesandbox.io/s/happy-hypatia-hu6e6?file=/src/index.js))

### Autoryzacja żądania

1. Pobieranie z użyciem komponentu GitHubUser ([uruchom](https://codesandbox.io/s/crazy-borg-xyw0m?file=/src/App.js))
2. Komponent GitHubUser i localStorage ([uruchom](https://codesandbox.io/s/brave-water-w7knz?file=/src/App.js))

### Obsługa informacji o stanie obietnic

1. Obsługa informacji o stanie ([uruchom](https://codesandbox.io/s/funny-architecture-9hwg4?file=/src/App.js))

### Generowane właściwości

1. Wyświetlanie listy ([uruchom](https://codesandbox.io/s/great-knuth-iq8qu?file=/src/App.js))
2. Pusta lista ([uruchom](https://codesandbox.io/s/eager-http-zgou9?file=/src/App.js))
3. Lista z danymi ([uruchom](https://codesandbox.io/s/affectionate-tdd-0mucp?file=/src/App.js))
4. Warunkowe generowanie funkcji właściwości ([uruchom](https://codesandbox.io/s/suspicious-sara-3dtyy?file=/src/App.js))

### Listy wirtualizowane

1. Generowanie listy za pomocą faker ([uruchom](https://codesandbox.io/s/holy-shape-634jj?file=/src/App.js))
2. Generowanie listy wirtualizowanej za pomocą react-window ([uruchom](https://codesandbox.io/s/keen-star-dfb08?file=/src/App.js))

### Zaczepy Fetch

1. Komponent Fetch ([uruchom](https://codesandbox.io/s/zen-cloud-7nin3?file=/src/App.js))
2. Dostosowanie do własnych potrzeb operacji wczytywania ([uruchom](https://codesandbox.io/s/agitated-raman-46dzb?file=/src/App.js))
3. Przewijanie zawartości repozytorium za pomocą useIterator ([uruchom](https://codesandbox.io/s/mystifying-cookies-nn1xl?file=/src/App.js))
4. Wykorzystywanie składni Markdown w Reactcie ([uruchom](https://codesandbox.io/s/cocky-fog-h6xde?file=/src/App.js))
