# Rozdział 2. JavaScript dla Reacta

Jeżeli jeszcze nie korzystasz z najnowszej składni JavaScriptu, teraz jest dobry moment na zmianę tego stanu rzeczy.

## Przykłady

### Deklarowanie zmiennych w ES6

#### Słowo kluczowe const

1. Bez słowa kluczowego const ([uruchom](http://jsbin.com/gapoxa/1/edit?js,console))
2. Ze słowem kluczowym const ❌ ([uruchom](https://jsbin.com/gapoxa/2/edit?js,console))

#### Słowo kluczowe let

3. Bez słowa kluczowego let ([uruchom](https://jsbin.com/gapoxa/3/edit?js,console))
4. Ze słowem kluczowym let ([uruchom](https://jsbin.com/gapoxa/4/edit?js,console))
5. Pętle z użyciem var ([uruchom](http://jsbin.com/gapoxa/5/edit?js,output))
6. Pętle z użyciem let ([uruchom](http://jsbin.com/gapoxa/6/edit?js,output))

#### Szablon ciągu tekstowego

7. Bez szablonu ciągu tekstowego - prosta konkatenacja ([uruchom](https://jsbin.com/gapoxa/7/edit?js,console))
8. Z szablonem ciągu tekstowego - prosta konkatenacja ([uruchom](https://jsbin.com/gapoxa/8/edit?js,console))
9. Szablon ciągu tekstowego - E-mail ([uruchom](https://output.jsbin.com/gapoxa/9))
10. Szablon ciągu tekstowego - HTML ([uruchom](https://jsbin.com/gapoxa/10/edit?js,output))

### Parametry domyślne

1. Parametry domyślne ([uruchom](http://jsbin.com/yeqexu/1/edit?js,console))
2. Parametry domyślne z obiektami ([uruchom](http://jsbin.com/yeqexu/2/edit?js,console))

### Funkcja strzałki

1. Zwykła funkcja
   ([uruchom](http://jsbin.com/tegefa/1/edit?js,console))
2. Funkcja strzałki ([uruchom](http://jsbin.com/tegefa/2/edit?js,console))
3. Funkcja strzałki - wiele argumentów ([uruchom](http://jsbin.com/tegefa/3/edit?js,console))
4. Wiele argumentów - jeden wiersz ([uruchom](http://jsbin.com/tegefa/4/edit?js,console))
5. Funkcje strzałki i konstrukcje if ❌ ([uruchom](http://jsbin.com/tegefa/5/edit?js,console))
6. Funkcje strzałki i błędy ❌ ([uruchom](http://jsbin.com/tegefa/6/edit?js,console))
7. setTimeout ❌ ([uruchom](http://jsbin.com/tegefa/7/edit?js,console))
8. setTimeout za pomocą .bind ([uruchom](http://jsbin.com/tegefa/8/edit?js,console))
9. setTimeout za pomocą funkcji strzałki ([uruchom](http://jsbin.com/tegefa/9/edit?js,console))
10. setTimeout i problem związany z 'this' ❌ ([uruchom](http://jsbin.com/tegefa/10/edit?js,console))
11. Pokazanie problemu związanego z 'this' ([uruchom](http://jsbin.com/tegefa/11/edit?js,console))

### Obiekty i tablice

#### Destrukturyzacja obiektu

1. Destrukturyzacja obiektu ([uruchom](http://jsbin.com/jukokaf/1/edit?js,console))
2. Destrukturyzacja z użyciem argumentów ([uruchom](http://jsbin.com/jukokaf/2/edit?js,console))
3. Destrukturyzacja obiektu z użyciem argumentów ([uruchom](http://jsbin.com/jukokaf/3/edit?js,console))
4. Destrukturyzacja tablic ([uruchom](http://jsbin.com/jukokaf/4/edit?js,console))
5. Destrukturyzacja z użyciem miejsc zarezerwowanycg ([uruchom](http://jsbin.com/jukokaf/5/edit?js,console))

#### Usprawnienia za pomocą literału obiektu

6. Usprawnienia za pomocą literału obiektu ([demo](https://rawgit.com/MoonHighway/learning-react/master/chapter-02/04-objects-and-arrays/06-object-literal-enhancement.html), [code](http://github.com/MoonHighway/learning-react/blob/master/chapter-02/04-objects-and-arrays/06-object-literal-enhancement.html), [bin](http://jsbin.com/jukokaf/6/edit?js,console))
7. Usprawnienia za pomocą literału obiektu i funkcji ([demo](https://rawgit.com/MoonHighway/learning-react/master/chapter-02/04-objects-and-arrays/07-object-literal-enhancement.html), [code](http://github.com/MoonHighway/learning-react/blob/master/chapter-02/04-objects-and-arrays/07-object-literal-enhancement.html), [bin](http://jsbin.com/jukokaf/7/edit?js,console))
8. Usprawnienia za pomocą literału obiektu: stary sposób ([demo](https://rawgit.com/MoonHighway/learning-react/master/chapter-02/04-objects-and-arrays/08-object-literal-enhancement.html), [code](http://github.com/MoonHighway/learning-react/blob/master/chapter-02/04-objects-and-arrays/08-object-literal-enhancement.html), [bin](http://jsbin.com/jukokaf/8/edit?js,console))
9. Usprawnienia za pomocą literału obiektu: obecnie ([demo](https://rawgit.com/MoonHighway/learning-react/master/chapter-02/04-objects-and-arrays/09-object-literal-enhancement.html), [code](http://github.com/MoonHighway/learning-react/blob/master/chapter-02/04-objects-and-arrays/09-object-literal-enhancement.html), [bin](http://jsbin.com/jukokaf/9/edit?js,console))

#### Operator rozszczepienia

10. Operator rozszczepienia i tablice ([uruchom](http://jsbin.com/jukokaf/10/edit?js,console))
11. Rozszczepianie tablic za pomocą .reverse() ([uruchom](http://jsbin.com/jukokaf/11/edit?js,console))
12. Operator rozszczepienia i destrukturyzacja za pomocą .reverse() ([uruchom](http://jsbin.com/jukokaf/12/edit?js,console))
13. Destrukturyzacja i operator rozszczepienia ([uruchom](http://jsbin.com/jukokaf/13/edit?js,console))
14. Funkcje kierunkowe ([uruchom](http://jsbin.com/jukokaf/14/edit?js,console))
15. Operator rozszczepienia i obiekty ([uruchom](http://jsbin.com/jukokaf/15/edit?js,console))

### Obietnice

1. getFakeMembers ([uruchom](http://jsbin.com/pupojik/1/edit?js,console))
2. fetch members ([uruchom](http://jsbin.com/haguhe/1/edit?js,console))

### Składnia klasy w ES6

1. Konstruktor i prototyp ([uruchom](http://jsbin.com/hoqileh/1/edit?js,console))
2. Klasy ([uruchom](http://jsbin.com/hoqileh/2/edit?js,console))
3. Dziedziczenie klas ([uruchom](http://jsbin.com/hoqileh/3/edit?js,console))
