# Rozdział 3. Programowanie funkcyjne w JavaScripcie

Wiele technik frameworka React stosuje styl programowania funkcyjnego JavaScriptu. Poznanie podstawowych koncepcji programowania funkcyjnego pomoże w tworzeniu lepszej struktury aplikacji Reacta.

## Przykłady

### Wprowadzenie

#### Co oznacza programowanie funkcyjne?

1. Funkcje jako zmienne ([uruchom](https://jsbin.com/hopomod/1/edit?js,console))
2. Funkcje strzałki ([uruchom](https://jsbin.com/hopomod/3/edit?js,console))
3. Metody obiektów ([uruchom](https://jsbin.com/lamujat/edit?js,console))
4. Funkcje w tablicach ([uruchom](https://jsbin.com/qoparag/edit?js,console))
5. Funkcje jako argumenty ([uruchom](https://jsbin.com/hopomod/5/edit?js,console))
6. Funkcje zwracane ([uruchom](https://jsbin.com/boyihum/1/edit?js,console))
7. Usprawnienia w ES6 ([uruchom](https://jsbin.com/boyihum/2/edit?js,console))

#### Styl imperatywny kontra styl deklaratywny

1. Imperatywny ([uruchom](https://jsbin.com/cuqapu/1/edit?js,console))
2. Declarative ([uruchom](http://jsbin.com/cuqapu/2/edit?js,console))

### Niemodyfikowalność

1. Modyfikowalność ([uruchom](http://jsbin.com/kemimi/1/edit?js,console))
2. Object.assign() ([uruchom](http://jsbin.com/kemimi/2/edit?js,console))
3. Operator rozszczepienia i obiekty ([uruchom](http://jsbin.com/kemimi/3/edit?js,console))
4. Array.push() ([uruchom](http://jsbin.com/kemimi/4/edit?js,console))
5. Array.concat() ([uruchom](http://jsbin.com/kemimi/5/edit?js,console))
6. Operator rozszczepienia i tablice ([uruchom](http://jsbin.com/kemimi/6/edit?js,console))

### Czyste funkcje

1. Funkcja nie będąca czystą ([uruchom](http://jsbin.com/kosogo/1/edit?js,console))
2. Zmiana obiektu ([uruchom](http://jsbin.com/kosogo/2/edit?js,console))
3. Czyste funkcje ([uruchom](http://jsbin.com/kosogo/3/edit?js,console))
4. Efekty uboczne ([uruchom](http://jsbin.com/kosogo/4/edit?js,console))
5. Komponent Reacta ([uruchom](http://jsbin.com/kosogo/5/edit?js,console))

### Konwersja danych

1. Złączanie tablic ([uruchom](http://jsbin.com/qehige/1/edit?js,console))
2. Filtrowanie tablic ([uruchom](http://jsbin.com/qehige/2/edit?js,console))
3. Funkcje filtrowania tablic ([uruchom](http://jsbin.com/qehige/3/edit?js,console))
4. Mapowanie tablic ([uruchom](http://jsbin.com/qehige/4/edit?js,console))
5. Tworzenie obiektów za pomocą .map() ([uruchom](http://jsbin.com/qehige/5/edit?js,console))
6. Uaktualnianie tablic obiektów ([uruchom](http://jsbin.com/qehige/6/edit?js,console))
7. Edytowanie tablic obiektów ([uruchom](http://jsbin.com/qehige/7/edit?js,console))
8. Object.keys() ([uruchom](http://jsbin.com/qehige/8/edit?js,console))
9. Redukowanie tablic ([uruchom](http://jsbin.com/qehige/9/edit?js,console))
10. Krótsza składnia Array.reduce()  ([uruchom](http://jsbin.com/qehige/10/edit?js,console))
11. Colors Hash ([uruchom](http://jsbin.com/qehige/11/edit?js,console))
12. distinctColors() ([uruchom](http://jsbin.com/qehige/12/edit?js,console))

### Funkcje wyższego rzędu

1. invokeIf ([uruchom](http://jsbin.com/raxuyew/1/edit?js,console))
2. userLogs ([uruchom](http://jsbin.com/raxuyew/2/edit?js,console))

### Rekurencja

1. Countdown ([uruchom](http://jsbin.com/romezi/1/edit?js,console))
2. Countdown with setTimeout ([uruchom](http://jsbin.com/romezi/2/edit?js,console))
3. deepPick() ([uruchom](http://jsbin.com/romezi/3/edit?js,console))

### Composition

1. Szablon wykorzystujący .replace() ([uruchom](http://jsbin.com/zivevu/1/edit?js,console))
2. Szablon wykorzystujący kompozycję ([uruchom](http://jsbin.com/zivevu/2/edit?js,console))
3. Kliknięcie z użyciem funkcji kompozycji ([uruchom](http://jsbin.com/zivevu/3/edit?js,console))
