# 1.	Po co używane są komponenty?
Komponenty są ważnym mechanizmem stosowanym w Reakcie. Umożliwiają one podział interfejsu użytkownika na mniejsze, niezależne porcje kodu. Dzięki temu można tworzyć bardziej skomplikowane interfejsy użytkownika, ponieważ programiści nie muszą pracować nad jednym dużym blokiem kodu.
Komponenty w Reakcie zwykle obejmują znaczniki (kod JSX) definiujące wyświetlaną treść i strukturę strony, a także logikę (kod JavaScript z dodatkowymi mechanizmami Reacta) i style (CSS).
# 2.	W jaki sposób można utworzyć komponent Reacta?
W trakcie pracy z Reactem komponenty Reacta można definiować na dwa różne sposoby:
•	jako klasy JavaScriptu,
•	jako funkcje JavaScriptu.
Pierwsze z tych podejść (klasy) nie jest już prawie stosowane i istnieje głównie z przyczyn historycznych. Domyślnym sposobem tworzenia komponentów w nowoczesnym Reakcie jest używanie funkcji JavaScriptu.
# 3.	Co powoduje, że zwykła funkcja staje się funkcją tworzącą komponent Reacta?
Tylko niektóre rodzaje funkcji tworzą komponenty Reacta. Przede wszystkim taka funkcja musi obejmować zawartość możliwą do wyświetlenia, na przykład kod JSX.
Ponadto gdy używasz niestandardowych funkcji tworzących komponenty jako komponentów w kodzie JSX, musisz stosować nazwy zaczynające się wielką literą, na przykład <SubmitButton />. Jest to wymagane w Reakcie do odróżniania niestandardowych komponentów od komponentów wbudowanych, które odpowiadają natywnym elementom HTML, na przykład <div> itd.
# 4.	O jakich podstawowych zasadach dotyczących elementów JSX należy pamiętać?
W trakcie pracy z kodem JSX należy pamiętać, że JSX nie jest ani HTML-em, ani zwykłym czystym JavaScriptem. JSX jest „lukrem składniowym” dostępnym w procesie kompilacji we wszystkich nowych projektach Reacta. Na zapleczu kod JSX jest przekształcany na zwykłe wywołania metod JavaScriptu.
W czasie używania kodu JSX trzeba przestrzegać kilku reguł:
•	gdy używasz niestandardowych komponentów w kodzie JSX, nazwy tych komponentów muszą się zaczynać wielką literą, na przykład <SubmitButton>;
•	w nazwach niestandardowych komponentów zwykle należy stosować NotacjęPascalową;
•	nazwy wbudowanych komponentów odpowiadających natywnym elementom HTML rozpoczynają się małą literą (na przykład <p>);
•	elementy puste (na przykład <img>) muszą być elementami samozamykającymi, czyli umożliwiać zapis <img/> zamiast <img>;
•	wartości w kodzie JSX przypominają zwykłe wartości z JavaScriptu, dlatego w miejscach, gdzie oczekiwana jest jedna wartość (na przykład po słowie kluczowym return), nie można umieszczać kilku równorzędnych wartości.

# 5.	W jaki sposób kod JSX jest obsługiwany przez Reacta i ReactDOM?
Kod JSX jest wykrywany i obsługiwany przez bibliotekę React. React i ReactDOM „tłumaczą” wyświetlaną zawartość, taką jak kod JSX, na instrukcje operujące modelem DOM.
Precyzyjnie rzecz ujmując, we wszystkich nowych projektach Reacta stosowany jest proces kompilacji, w którym kod JSX jest przekształcany w wywołania metody React.createElement(…). Następnie to właśnie instrukcja React.createElement(…) jest otrzymywana i przetwarzana przez bibliotekę React. Ostatecznie wspomniane wcześniej instrukcje do operowania modelem DOM są generowane przez pakiet ReactDOM.
