/* @flow */

'use strict';

import Actions from './components/Actions';
import Button from './components/Button';
import CRUDStore from './flux-imm/CRUDStore';
import Dialog from './components/Dialog';
import Form from './components/Form';
import FormInput from './components/FormInput';
import Logo from './components/Logo';
import Rating from './components/Rating';
import React from 'react';
import ReactDOM from 'react-dom';
import Suggest from './components/Suggest';
import schema from './schema';

CRUDStore.init(schema);

ReactDOM.render(
  <div style={{padding: '20px'}}>
    <h1>Wykrywacz komponentów</h1>

    <h2>Logo</h2>
    <div style={{display: 'inline-block', background: 'purple'}}><Logo /></div>

    <h2>Przyciski</h2>
    <div>Przyciski z onClick: <Button onClick={() => alert('au!')}>Kliknij mnie</Button></div>
    <div>Łącze: <Button href="http://reactjs.com">Idź za mną</Button></div> 
    <div>Nazwa klasy custom: <Button className="custom">Nic nie robię</Button></div> 

    <h2>Suggest</h2>
    <Suggest options={['eenie', 'meenie', 'miney', 'mo']} />

    <h2>Ocena</h2>
    <div>Brak wartości początkowej: <Rating /></div>
    <div>Początkowa wartość 4: <Rating defaultValue={4} /></div>
    <div>Tutaj najwyższa wartość wynosi 11: <Rating max={11}/></div>
    <div>Tylko do odczytu: <Rating readonly={true} defaultValue={3} /></div>

    <h2>Elementy formularza</h2>
    <table><tbody>
      <tr>
        <td>Zwykły element formularza</td>
        <td><FormInput /></td>
      </tr>
      <tr>
        <td>Wstępnie wypełniony</td>
        <td><FormInput defaultValue="it's like a default" /></td>
      </tr>
      <tr>
        <td>Rok</td>
        <td><FormInput type="year" /></td>
      </tr>
      <tr>
        <td>Ocena</td>
        <td><FormInput type="rating" defaultValue={4} /></td>
      </tr>
      <tr>
        <td>Sugestia</td>
        <td><FormInput 
          type="suggest" 
          options={['czerwony', 'zielony', 'niebieski']} 
          defaultValue="zielony" /></td>
      </tr>
      <tr>
        <td>Zwykły obszar tekstowy</td>
        <td><FormInput type="text" /></td>
      </tr>
    </tbody></table>

    <h2>Form</h2>

    <Form />

    <h2>Formularz tylko do odczytu</h2>

    <Form readonly={true} recordId={0} />

    <h2>Akcje</h2>
    <div><Actions onAction={type => alert(type)} /></div>

    <h2>Okno dialogowe</h2>
    <div><Dialog 
      header="Gotowy przykład" 
      onAction={type => alert(type)}>
        Witaj w oknie dialogowym!
      </Dialog></div>
    <p>&nbsp;</p>
    <div><Dialog 
        header="Bez anulowania, z niestandardowym przyciskiem" 
        hasCancel={false}
        confirmLabel="Cokolwiek"
        onAction={type => alert(type)}>
        Tutaj jest miejsce na cokolwiek, patrz: <Button>Przycisk</Button>
        </Dialog></div>
    
    
    {/* więcej komponentów... */}

  </div>,
  document.getElementById('pad')
);

