import classification from './classification';

const schema = {
  name: {
      label: 'Nazwa',
      show: true, 
      samples: ['$2 Chuck', 'Chateau React', 'Vint.js'],
      align: 'left', 
   },
   year: {
      label: 'Rok',
      type: 'year',
      show: true,
      samples: [2015, 2013, 2021],
   },
   grape: {
      label: 'Szczep',
      type: 'suggest',
      options: classification.grapes,
      show: true,
      samples: ['Merlot', 'Bordeaux Blend', 'Zinfandel'],
      align: 'left',
   },
   rating: {
      label: 'Ocena',
      type: 'rating',
      show: true,
      samples: [3, 1, 5],
   },
   comments: {
      label: 'Komentarze',
      type: 'text',
      samples: ['niezłe, jak na tę cenę', 'XML w moim kodzie JS??!', 'Lodi? Znów!'],
   },
};

export default schema;
