import PropTypes from 'prop-types';
import './Actions.css';

import deleteImage from './../images/close.svg';
import editImage from './../images/edit.svg';

import Button from './Button';

const Actions = ({onAction = () => {}}) => (
  <span className="Actions">
    <Button
      className="ActionsInfo"
      title="Więcej informacji"
      onClick={() => onAction('info')}>
      Wyświetl szczegóły
    </Button>
    <Button
      title="Edycja"
      onClick={() => onAction('edit')}>
      <img src={editImage} alt="Edycja" />
    </Button>
    <Button
      tabIndex="0"
      title="Usuń"
      onClick={onAction.bind(null, 'delete')}>
      <img src={deleteImage} alt="Usuń" />
    </Button>
  </span>
);

Actions.propTypes = {
  onAction: PropTypes.func,
};

export default Actions;
