import React, { Component, PropTypes } from 'react';
import { DragDropContext } from 'react-dnd';
import HTML5Backend from 'react-dnd-html5-backend';

import List from './List';

class KanbanBoard extends Component {
  render(){
    return (
      <div className="app">
        <List id='todo'
              title="Do zrobienia"
              cards={this.props.cards.filter((card) => card.status === "todo")}
              cardCallbacks={this.props.cardCallbacks}
              taskCallbacks={this.props.taskCallbacks} />
        <List id='in-progress'
              title="W toku"
              cards={this.props.cards.filter((card) => card.status === "in-progress")}
              cardCallbacks={this.props.cardCallbacks}
              taskCallbacks={this.props.taskCallbacks} />
        <List id='done'
              title='Zrobione'
              cards={this.props.cards.filter((card) => card.status === "done")}
              cardCallbacks={this.props.cardCallbacks}
              taskCallbacks={this.props.taskCallbacks} />
      </div>
    );
  }
};
KanbanBoard.propTypes = {
  cards: PropTypes.arrayOf(PropTypes.object),
  cardCallbacks: PropTypes.object,
  taskCallbacks: PropTypes.object
};

export default DragDropContext(HTML5Backend)(KanbanBoard);
