// Zależności
import { FC, ReactElement, useState, ChangeEvent } from 'react'
import { redirectTo } from '@contentpi/lib'

// Interfejsy
import { IUser } from '../../types'

// Style
import { StyledLogin } from './Login.styled'

interface IProps {
  login(input: any): any
  currentUrl: string
}

const Login: FC<IProps> = ({ login, currentUrl }): ReactElement => {
  // Stany
  const [values, setValues] = useState({
    email: '',
    password: ''
  })
  const [errorMessage, setErrorMessage] = useState('')
  const [invalidLogin, setInvalidLogin] = useState(false)

  // Metody
  const onChange = (e: ChangeEvent<HTMLInputElement>): any => {
    const {
      target: { name, value }
    } = e

    if (name) {
      setValues((prevValues: any) => ({
        ...prevValues,
        [name]: value
      }))
    }
  }

  const handleSubmit = async (user: IUser): Promise<void> => {
    // W tym miejscu stosowane jest przekształcenie logowania
    const response = await login(user)

    if (response.error) {
      // Jeśli logowanie jest niepoprawne...
      setInvalidLogin(true)
      setErrorMessage(response.message)
    } else {
      // Jeśli logowanie jest poprawne...
      redirectTo(currentUrl || '/')
    }
  }

  return (
    <>
      <StyledLogin>
        <div className="wrapper">
          {invalidLogin && <div className="alert">{errorMessage}</div>}
          <div className="form">
            <p>
              <input
                autoComplete="off"
                type="email"
                className="email"
                name="email"
                placeholder="Adres e-mail"
                onChange={onChange}
                value={values.email}
              />
            </p>

            <p>
              <input
                autoComplete="off"
                type="password"
                className="password"
                name="password"
                placeholder="Hasło"
                onChange={onChange}
                value={values.password}
              />
            </p>

            <div className="actions">
              <button name="login" onClick={(): Promise<void> => handleSubmit(values)}>
                Zaloguj się
              </button>
            </div>
          </div>
        </div>
      </StyledLogin>
    </>
  )
}

export default Login
