// Zależności
import { Sequelize } from 'sequelize'

// Konfiguracja
import { $db } from '../../config'

// Interfejsy
import { IModels } from '../types'

// Połączenie z bazą danych
const { dialect, port, host, database, username, password } = $db

// Nawiązywanie połączenia z bazą danych
const uri = `${dialect}://${username}:${password}@${host}:${port}/${database}`
const sequelize = new Sequelize(uri)

// Modele
const models: IModels = {
  User: require('./User').default(sequelize, Sequelize),
  sequelize
}

export default models
