// Zależności
import React, { FC, useState, useEffect } from 'react'
import axios from 'axios'

// Typy
type Issue = {
  number: number
  title: string
  url: string
  state: string
}

const Issues: FC = () => {
  // Funkcja Hook useState zastępuje metodę this.setState
  const [issues, setIssues] = useState<Issue[]>([])

  // W wypadku użycia funkcji Hook useEffect z pustą tablicą [] w
  // zależnościach (drugi parametr)
  // kod reprezentuje metodę componentDidMount (zostanie zastosowana w
  // momencie podłączania komponentu).

  useEffect(() => {
    axios
      .get('https://api.github.com/repos/ContentPI/ContentPI/issues')
      .then((response: any) => {
        // W tym miejscu bezpośrednio aktualizowany jest stan problemu
        setIssues(response.data)
      })
  }, [])  

  return (
    <>
      <h1>ContentPI - problemy</h1>

      {issues.map((issue: Issue) => (
        <p>
          <strong>#{issue.number}</strong> {' '}
          <a href={`https://github.com/ContentPI/ContentPI/issues/${issue.number}`} target="_blank">{issue.title}</a> {' '}
          {issue.state}
        </p>
      ))}
    </>
  )
}

export default Issues