import { render, cleanup } from '@testing-library/react'

import Hello from './index'

describe('Komponent Hello', () => {
  it('powinien renderować łańcuch Witaj, świecie', () => {
    const wrapper = render(<Hello />)
    expect(wrapper.getByText('Witaj, świecie')).toBeInTheDocument()
  })

  it('powinien renderować własność imienia', () => {
    const wrapper = render(<Hello name="Cezary" />)
    expect(wrapper.getByText('Witaj, Cezary')).toBeInTheDocument()
  });

  it('powinien zawierać nazwę klasy .Home', () => {
    const wrapper = render(<Hello />)
    expect(wrapper.container.firstChild).toHaveClass('Hello')
  });

  afterAll(cleanup)
})
