import { FC, useState } from 'react'
import { Link } from 'react-router-dom'
import './Contacts.css'

const data = [
  {
    id: 1,
    name: 'Cezary Szewczyk',
    email: 'cezary.szewczyk@dew.edukacja',
    phone: '415-307-3112'
  },
  {
    id: 2,
    name: 'Jan Nowak',
    email: 'jan.nowak@dew.edukacja',
    phone: '223-344-5122'
  },
  {
    id: 3,
    name: 'Aleksy Nowak',
    email: 'aleksy.nowak@dew.edukacja',
    phone: '664-291-4477'
  }
]

type Contact = {
  id: number
  name: string
  email: string
  phone: string
}

type Props = {
  match: any
}

const Contacts: FC<Props> = (props) => {
  // Na razie osoby kontaktowe zostaną dodane do
  // lokalnego stanu, ale standardowo powinny pochodzić
  // z jakiejś usługi.
  const [contacts, setContacts] = useState<Contact[]>(data)

  // Sprawdźmy, co zawiera obiekt własności match.
  console.log(props)

  const { match: { params: { contactId } } } = props
  
  // Domyślnie selectedNote ma wartość false.
  let selectedContact: any = false
  
  if (contactId > 0) {
    // Jeśli identyfikator osoby kontaktowej jest większy niż 0, jest ona odfiltrowywana z
    // tablicy osób kontaktowych.
    selectedContact = contacts.filter(
      contact => contact.id === Number(contactId)
    )[0];
  }

  const renderSingleContact = ({ name, email, phone }: Contact) => (
    <>
      <h2>{name}</h2>
      <p>{email}</p>
      <p>{phone}</p>
    </>
  )

  const renderContacts = () => (
    <ul>
      {contacts.map((contact: Contact, key) => (
        <li key={key}>
          <Link to={`/contacts/${contact.id}`}>{contact.name}</Link>
        </li>
      ))}
    </ul>
  )

  return (
    <div className="Contacts">
      <h1>Osoby kontaktowe</h1>
      {/* Renderowanie elementu selectedContact lub wszystkich osób kontaktowych */}
      {selectedContact
        ? renderSingleContact(selectedContact)
        : renderContacts()}
    </div>
  )
}

export default Contacts