// Zależności
import { FC, ReactElement } from 'react'
import { isBrowser } from '@contentpi/lib'

// Konteksty
import UserProvider from '../contexts/user'

// Komponenty
import LoginLayout from '../components/users/LoginLayout'

interface IProps {
  currentUrl: string
}

const Page: FC<IProps> = ({
  currentUrl = isBrowser() ? window.location.search.replace('?redirectTo=', '') : ''
}): ReactElement => (
  <UserProvider page="login">
    <LoginLayout currentUrl={currentUrl} />
  </UserProvider>
)

export default Page
