// Zależności
import { FC, ReactElement, useContext } from 'react'

// Konteksty
import { UserContext } from '../../contexts/user'

// Komponenty
import Dashboard from './Dashboard'

const Layout: FC = (): ReactElement => {
  const { connectedUser } = useContext(UserContext)

  if (connectedUser) {
    return (
      <Dashboard connectedUser={connectedUser} />
    )
  }

  return <div />
}

export default Layout
