// Zależności
import { FC, useContext } from 'react'

// Konteksty
import { IssueContext, Issue } from '../contexts/Issue'

const Issues: FC = () => {
  // Używany jest tutaj kontekst i możliwe jest uzyskanie wartości powiązanych z problemami.
  const { issues, url } = useContext(IssueContext)

  return (
    <>
      <h1>ContentPI - problemy (z kontekstu)</h1>

      {issues.map((issue: Issue) => (
        <p key={`issue-${issue.number}`}>
          <strong>#{issue.number}</strong> {' '}
          <a href={`${url}/${issue.number}`}>{issue.title}</a> {' '}
          {issue.state}
        </p>
      ))}
    </>
  )
}

export default Issues