# React 17 Design Patterns and Best Practices-Third Edition

<a href="https://www.packtpub.com/product/react-17-design-patterns-and-best-practices-third-edition/9781800560444"><img src="https://static.packt-cdn.com/products/9781800560444/cover/smaller" alt="React 17 Design Patterns and Best Practices" height="256px" align="right"></a>

This is the code repository for [React 17 Design Patterns and Best Practices-Third Edition](https://www.packtpub.com/product/react-17-design-patterns-and-best-practices-third-edition/9781800560444), published by Packt.

**Design, build, and deploy production-ready web applications using industry-standard practices**

## What is this book about?
React is an open-source, adaptable JavaScript library for building complex user interfaces (UIs) from small, detached bits called components. This book will help you to use React effectively to make your applications more flexible, easier to maintain, and improve their performance, while giving your workflow a huge boost by improving speed without affecting quality.

This book covers the following exciting features: 
* Become well-versed with new React features such as context API and React Hooks
* Get to grips with the techniques of styling and optimizing React components
* Make components communicate with each other by applying consolidated patterns
* Use server-side rendering to make applications load faster
* Write a comprehensive set of tests to create robust and maintainable code

If you feel this book is for you, get your [copy](https://www.amazon.com/dp/1800560443) today!

<a href="https://www.packtpub.com/?utm_source=github&utm_medium=banner&utm_campaign=GitHubBanner"><img src="https://raw.githubusercontent.com/PacktPublishing/GitHub/master/GitHub.png" 
alt="https://www.packtpub.com/" border="5" /></a>


## Instructions and Navigations
All of the code is organized into folders. For example, Chapter01.

The code will look like the following:
```
const toUpperCase = input => { 
  const output = []
   
  for (let i = 0; i < input.length; i++) { 
    output.push(input[i].toUpperCase())
  } 
    
  return output
}
```

**Following is what you need for this book:**
This book is for web developers who want to increase their understanding of React and apply it to real-life app development. Intermediate-level experience with React and JavaScript is assumed.

With the following software and hardware list you can run all code files present in the book (Chapter 1-15).

### Software and Hardware List

| Chapter  | Software required                   | OS required                        |
| -------- | ------------------------------------| -----------------------------------|
|1-15     | React 17                    | Windows, Mac OS X, and Linux (Any) |
|1-15       | VS Code            | Windows, Mac OS X, and Linux (Any) |
|1-15        | Node.js +12           | Windows, Mac OS X, and Linux (Any) |
| 14       | DigitalOcean account            | Windows, Mac OS X, and Linux (Any) |
| 14        | Ubuntu LTS 20.14            | Windows, Mac OS X, and Linux (Any) |
| 14        | GoDaddy domain            | Windows, Mac OS X, and Linux (Any) |
| 14        | CircleCi            | Windows, Mac OS X, and Linux (Any) |
| 15        |npm account            | Windows, Mac OS X, and Linux (Any) |

We also provide a PDF file that has color images of the screenshots/diagrams used in this book. [Click here to download it](https://static.packt-cdn.com/downloads/9781800560444_ColorImages.pdf).

### Related products <Other books you may enjoy>
* The React Workshop [[Packt]](https://www.packtpub.com/product/the-react-workshop/9781838645564) [[Amazon]](https://www.amazon.in/dp/183864556X)

* Full-Stack React, TypeScript, and Node [[Packt]](https://www.packtpub.com/product/full-stack-react-typescript-and-node/9781839219931) [[Amazon]](https://www.amazon.com/dp/1839219939)

## Get to Know the Author
**Carlos Santana Roldán**
is a senior web developer with more than 13 years of experience. Currently, he is working as a Senior Software Engineer at Snap Inc. He is the founder of Dev Education, one of the most popular developer communities in Latin America, training people in web technologies such as React, Node.

## Other books by the author
* [React Cookbook](https://www.packtpub.com/product/react-cookbook/9781783980727)




