#!/usr/bin/env python
# Zamek do drzwi: system kontrolujący elektryczny zamek do drzwi
# Wersja z kodem generującym impuls otwierający drzwi

import piface.pfio as piface
from time import sleep

class AuthToken:
    def __init__(self, id, secret):
        self.id=id
        self.secret=secret
        
class TestDoorController:
    def send_open_pulse(self):
        print "Otwarcie drzwi"

class DoorControllerPiFace:
    def __init__(self):
        piface.init()
    def send_open_pulse(self):
        piface.digital_write(0,1)
        sleep(5)
        piface.digital_write(0,0)
        
class BasicAuthenticator:
    id = "Andrzej"
    secretPassword = "1234"
    
    def check(self,token):
        print "Porównywanie wprowadzonego hasła użytkownika '" + token.id + "': " + token.secret + " z tajnym hasłem '" + self.secretPassword +"'"
        result = (token.secret == self.secretPassword) & (token.id == self.id)
        print "Wynik uwierzytelniania: " + str(result)
        return result
        
class FileAuthenticator:
    filename = "secrets.txt"
    def readFile(self):
        secrets = open(self.filename, 'r')
        print "Wczytywanie danych z pliku"
        for line in secrets:
            line = line.rstrip('\n')
            self.id, self.secretPassword = line.split(',')

    def check(self,token):
        self.readFile()
        print "Porównywanie wprowadzonego hasła użytkownika '" + token.id + "': " + token.secret + " z tajnym hasłem '" + self.secretPassword +"'"
        result = (token.secret == self.secretPassword) & (token.id == self.id)
        print "Wynik uwierzytelniania: " + str(result)
        return result
       
        
class TestInput:
    def getInput(self):
        print "Sprawdzanie danych wejściowych"
        authToken = AuthToken("Andrzej","1234")
        return authToken
        
class KeyboardInput:
    def getInput(self):
        print "Sprawdzanie danych wejściowych"
        id = raw_input("Podaj nazwę użytkownika: ")
        password = raw_input("Podaj hasło: ")
        authToken = AuthToken(id,password)
        return authToken

    
def main():
    #authInput = TestInput()
    authInput = KeyboardInput()
    #authenticator = BasicAuthenticator()
    authenticator = FileAuthenticator()
    #doorController = TestDoorController()
    doorController = DoorControllerPiFace()
    if(authenticator.check(authInput.getInput())):
        doorController.send_open_pulse()
        
if __name__ == '__main__':
    main()



