#---
# Excerpted from "Rails Recipes"
# We make no guarantees that this code is fit for any purpose. 
# Visit http://www.pragmaticprogrammer.com/titles/fr_rr for more book information.
#---
class ApplicationController < ActionController::Base
  def self.search_action_for(table, options = {})
    model_class = Object.const_get(table.classify) 
    define_method(:search) do
      search_code = lambda do 
        @title = options[:title] || "Your #{table.humanize}"
        search_column = options[:search_column] || 'name'
        @display_as = options[:display_as] || :name
        @display_action = options[:display_action] || "view"         
        @results = model_class.find(:all, :conditions => 
                         ["#{search_column} like ?", "%#{params[:term]}%"])
        render :template => 'shared/search_results'      
      end
      (options[:scoped] == false) ?  
           search_code.call : scope(model_class, &search_code) 
    end
  end
  def scope(model_class, &block)
    model_class.with_scope(
       :find => { :conditions => ['account_id = ?', current_user.account_id] }, 
        &block)
  end
end
