#---
# Excerpted from "Rails Recipes"
# We make no guarantees that this code is fit for any purpose. 
# Visit http://www.pragmaticprogrammer.com/titles/fr_rr for more book information.
#---
class GraphController < ApplicationController

require 'gruff'

  STATS_DIRECTORIES = [
    %w(Metody\ pomocnicze   app/helpers), 
    %w(Kontrolery          app/controllers), 
    %w(API                 app/apis),
    %w(Komponenty          components),
    %w(Testy\ funkcjonalne test/functional),
    %w(Modele              app/models),
    %w(Testy\ jednostkowe  test/unit),
    %w(Biblioteki          lib/),
    %w(Testy\ integracyjne test/integration)
  ].collect { |name, dir| 
      [ name, "#{RAILS_ROOT}/#{dir}" ] 
    }.select { |name, dir| 
      File.directory?(dir) 
    }
  def stats
    code_stats = CodeStatistics.new(*STATS_DIRECTORIES)
    statistics = code_stats.instance_variable_get(:@statistics)
    g = Gruff::Pie.new(500)
    g.font = "/Library/Fonts/Arial"
    g.title = "Statystyki kodu"
    g.theme_37signals
    g.legend_font_size = 10
    0xFDD84E.step(0xFF0000, 1500) do |num|
      g.colors << "#%x"  % num
    end
    statistics.each do |key, values|
      g.data(key, [values["codelines"]])
    end
    send_data(g.to_blob, 
                :disposition => 'inline', 
                :type => 'image/png', 
                :filename => "code_stats.png")
  end
#KONIEC



end
