#---
# Excerpted from "Rails Recipes"
# We make no guarantees that this code is fit for any purpose. 
# Visit http://www.pragmaticprogrammer.com/titles/fr_rr for more book information.
#---
class Grade
  include Comparable
  attr_accessor :letter_grade
  SORT_ORDER = ["f", "d", "c", "b", "a"].inject({}) {|h, letter|
    h.update "#{letter}-" => h.size
    h.update letter => h.size
    h.update "#{letter}+" => h.size
  }
  def initialize(letter_grade)
    @letter_grade = letter_grade
  end
  def <=>(other)
    SORT_ORDER[letter_grade.downcase] <=> SORT_ORDER[other.letter_grade.downcase]
  end
end
