#---
# Excerpted from "Rails Recipes"
# We make no guarantees that this code is fit for any purpose. 
# Visit http://www.pragmaticprogrammer.com/titles/fr_rr for more book information.
#---
class AccountsController < ApplicationController
  
  def login
    case request.method
    when :post 
      begin 
        user = User.authenticate(@params[:email], @params[:password])
        session[:user] = user.id
        session[:locale] = user.locale
        go_to = session[:destination]
        session[:destination] = nil
        redirect_to (go_to || home_url) unless performed?
      rescue User::InvalidLoginException => e
        flash[:notice] = e.message
        redirect_to login_url unless performed?
      end
    when :get
    end
  end

  def logout
    @session[:user] = nil
    redirect_to home_url
  end  
  
  def change_locale
    session[:locale] = params[:locale] unless params[:locale].blank?
    redirect_to :back
  end  
  
end
