﻿#---
# Excerpted from "Rails Recipes"
# We make no guarantees that this code is fit for any purpose. 
# Visit http://www.pragmaticprogrammer.com/titles/fr_rr for more book information.
#---class CreatePeopleAndClubsTables < ActiveRecord::Migration
  class CreatePeopleAndClubsTables < ActiveRecord::Migration
  def self.up
    create_table :people do |t|
      t.column :name, :string
    end
    
    create_table :clubs do |t|
      t.column :name, :string
    end
    
    create_table :clubs_people, :id => false do |t|
      t.column :person_id, :integer
      t.column :club_id, :integer
    end
    
    chad = Person.create(:name => "Chad")
    kelly = Person.create(:name => "Kasia")
    james = Person.create(:name => "Janek")
    
    hindi_club = Club.create(:name => "Koło hinduskie")
    snow_boarders = Club.create(:name => "Nauka snowboardu")
    
    chad.clubs.concat [hindi_club, snow_boarders]
    kelly.clubs.concat [hindi_club, snow_boarders]
    james.clubs.concat [snow_boarders]
    [chad, kasia, janek].each {|person| person.save}
  end

  def self.down
    drop_table :people
    drop_table :clubs
    drop_table :clubs_people
  end
end
