#---
# Excerpted from "Rails Recipes"
# We make no guarantees that this code is fit for any purpose. 
# Visit http://www.pragmaticprogrammer.com/titles/fr_rr for more book information.
#---
class AdminController < ApplicationController

  before_filter :check_authentication, :except => [:signin]

  def check_authentication
    unless session[:user]
      session[:intended_action] = action_name
      session[:intended_controller] = controller_name      
      redirect_to :action => "signin"
    end
  end

  def signin
    session[:user] = User.authenticate(params[:username], 
                     params[:password]).id
    redirect_to :action => session[:intended_action],
                :controller => session[:intended_controller]
  end

  def signout
    session[:user] = nil
    redirect_to home_url
  end
  # ...prawdziwe akcje kontrolera mona umieci tu.

end
