"""
Wczytuje obrazy, liczy średnią intensywność i rysuje wykres zmian
względnej intensywności w czasie.
"""
import os
from statistics import mean
import cv2 as cv
import numpy as np
import matplotlib.pyplot as plt
from scipy import signal  # Zob. rozdział 1., aby zainstalować scipy.

# Przechodzi do katalogu zawierającego obrazy.
os.chdir('br549_pixelated')
images = sorted(os.listdir())
intensity_samples = []

# Przekształca obrazy do skali szarości
# i tworzy listę średnich wartości intensywności.
for image in images:
    img = cv.imread(image, cv.IMREAD_GRAYSCALE)
    intensity = img.mean()
    intensity_samples.append(intensity)

# Tworzy listę wartości względnej intensywności.
rel_intensity = intensity_samples[:]
max_intensity = max(rel_intensity)
for i, j in enumerate(rel_intensity):
    rel_intensity[i] = j / max_intensity

# Rysuje wartości względnej intensywności na osi liczby ramek
# (w zastępstwie czasu).
plt.plot(rel_intensity, color='red', marker='o', linestyle='solid',
         linewidth=2, markersize=0, label='Względna intensywność')
plt.legend(loc='upper center')
plt.title('Zmiany względnej intensywności egzoplanety BR549 w czasie')
plt.ylim(0.8, 1.1)
plt.xticks(np.arange(0, 50, 5))
plt.grid()
print("\nRecznie zamknij okno programu po zapoznaniu sie z wykresem, "
      "aby przejsc do dalszej czesci programu.")
plt.show()

# Znajduje okres / długość dnia.
# Oszacowuje najwyższe wartości i odległość między nimi na wykresie.
# Parametry wysokości i odległości to limity >=.
peaks = signal.find_peaks(rel_intensity, height=0.95, distance=5)
print(f"peaks = {peaks}")
print("Okres = {}".format(mean(np.diff(peaks[0]))))
