"""Rysuje trójwymiarowy wykres mapy MOLA. Autor: Eric T. Mortenson."""
import numpy as np
import cv2 as cv
import matplotlib.pyplot as plt

IMG_GRAY = cv.imread('mola_1024x512_200mp.jpg', cv.IMREAD_GRAYSCALE)

x = np.linspace(1023, 0, 1024)
y = np.linspace(0, 511, 512)

X, Y = np.meshgrid(x, y)
Z = IMG_GRAY[0:512, 0:1024]

fig = plt.figure()
ax = plt.axes(projection='3d')
ax.contour3D(X, Y, Z, 150, cmap='gist_earth')  # 150=liczba izolinii
ax.auto_scale_xyz([1023, 0], [0, 511], [0, 500])
plt.show()
