"""Tworzy wykres słupkowy znaków w pliku tekstowym."""
import operator
import os
import sys
from collections import Counter
import matplotlib.pyplot as plt


def load_file(infile):
    """
    Odczytuje i zwraca plik tekstowy jako ciąg znaków
    złożony z małych liter.
    """
    with open(infile) as f:
        text = f.read().lower()
    return text


def main():
    infile = 'lost.txt'
    if not os.path.exists(infile):
        print("Nie znaleziono pliku {}. Program konczy dzialanie."
              .format(infile), file=sys.stderr)
        sys.exit(1)

    text = load_file(infile)

    # Tworzy wykres słupkowy przedstawiający częstość występowania
    # znaków w tekście.
    char_freq = Counter(text)
    char_freq_sorted = sorted(char_freq.items(),
                              key=operator.itemgetter(1), reverse=True)
    x, y = zip(*char_freq_sorted)  # Gwiazdka (*) rozpakowuje kolekcję.
    fig, ax = plt.subplots()
    ax.bar(x, y)
    fig.show()


if __name__ == '__main__':
    main()
