import os
from datetime import datetime
import cv2 as cv

names = {1: "Demming"}  # Wpisz swój identyfikator i nazwisko.

# Określa ścieżkę do algorytmu wykrywającego twarz.
cascade_path = "C:/Python39/Lib/site-packages/cv2/data/"
face_detector = cv.CascadeClassifier(cascade_path +
                                     'haarcascade_frontalface_default.xml')

# Określa ustawienia algorytmu do rozpoznawania twarzy
# i wgrywa dane szkoleniowe.
recognizer = cv.face.LBPHFaceRecognizer_create()
recognizer.read('lbph_trainer.yml')

# Określa ustawienia danych testowych.
# Użyj katalogu tester w przypadku korzystania z obrazów własnych (odkomentuj).
# test_path = './tester'
# Użyj katalogu demming_tester w przypadku korzystania z gotowych obrazów.
test_path = './demming_tester'

image_paths = [os.path.join(test_path, f) for f in os.listdir(test_path)]

# Tworzy pętlę przez obrazy i przewiduje tożsamość.
for image in image_paths:
    predict_image = cv.imread(image, cv.IMREAD_GRAYSCALE)
    faces = face_detector.detectMultiScale(predict_image,
                                           scaleFactor=1.05,
                                           minNeighbors=5)
    for (x, y, w, h) in faces:
        print(f"\n[{datetime.now()}] Otrzymano zadanie dostepu.")
        face = cv.resize(predict_image[y:y + h, x:x + w], (100, 100))
        predicted_id, dist = recognizer.predict(face)
        if predicted_id == 1 and dist <= 95:
            name = names[predicted_id]
            print("Osoba na obrazie {}: {} (odleglosc = {})"
                  .format(image, name, round(dist, 1)))
            print(f"Zezwolono na dostep (uzytkownik: {name}, data:"
                  f" {datetime.now()}).", file=open('lab_access_log.txt', 'a'))
        else:
            name = 'nie rozpoznano'
            print(f"Osoba na obrazie {image}: {name}")

        cv.rectangle(predict_image, (x, y), (x + w, y + h), 255, 2)
        cv.putText(predict_image, name, (x + 1, y + h - 5),
                   cv.FONT_HERSHEY_SIMPLEX, 0.5, 255, 1)
        cv.imshow('ID', predict_image)
        cv.waitKey(2000)
        cv.destroyAllWindows()
