"""
Sprawdza, czy elementy rysowane z użyciem biblioteki OpenCV 
stanowią część obrazu.
"""
import numpy as np
import cv2 as cv

IMG = cv.imread('mola_1024x501.png', cv.IMREAD_GRAYSCALE)

ul_x, ul_y = 0, 167
lr_x, lr_y = 32, 183
rect_img = IMG[ul_y : lr_y, ul_x : lr_x]


def run_stats(image):
    """Wylicza statystyki dla tablicy numpy reprezentującej obraz."""
    print('średnia = {}'.format(np.mean(image)))
    print('odchylenie standardowe = {}'.format(np.std(image)))
    print('amplituda wysokości = {}'.format(np.ptp(image)))
    print()
    cv.imshow('img', IMG)
    cv.waitKey(1000)    


# Statystyki obrazu bez rysunków:
print("Bez rysunków")
run_stats(rect_img)

# Statystyki obrazu z konturem białego prostokąta:
print("Biały prostokąt bez wypełnienia")
cv.rectangle(IMG, (ul_x, ul_y), (lr_x, lr_y), (255, 0, 0), 1)
run_stats(rect_img)

# Statystyki obrazu z białym prostokątem z wypełnieniem:
print("Biały prostokąt z wypełnieniem")
cv.rectangle(IMG, (ul_x, ul_y), (lr_x, lr_y), (255, 0, 0), -1)
run_stats(rect_img)
