"""
Zmniejsza obraz do rozmiaru 3 x 3 i tworzy wykres średnich
składowych BGR.
"""

import numpy as np
import cv2 as cv
from matplotlib import pyplot as plt

files = ['earth_west.png', 'earth_east.png']

# Zmniejsza obraz do rozmiarów 3 x 3 pikseli.
for file in files:
    img_ini = cv.imread(file)
    pixelated = cv.resize(img_ini, (3, 3), interpolation=cv.INTER_AREA)
    img = cv.resize(pixelated, (300, 300), interpolation=cv.INTER_AREA)
    cv.imshow('Obraz {}'.format(file), img)
    cv.waitKey(2000)

    # Rozdziela i uśrednia wartości z poszczególnych kanałów kolorów.
    b, g, r = cv.split(pixelated)
    color_aves = []
    for array in (b, g, r):
        color_aves.append(np.average(array))

    # Tworzy diagramy kołowe.
    labels = 'Niebieski', 'Zielony', 'Czerwony'
    colors = ['blue', 'green', 'red']
    fig, ax = plt.subplots(figsize=(3.5, 4.0))  # Rozmiar w calach
    _, _, autotexts = ax.pie(color_aves,
                             labels=labels,
                             autopct='%1.1f%%',
                             colors=colors)
    for autotext in autotexts:
        autotext.set_color('white')
    plt.title('{}\n'.format(file))

plt.show()
