#!/usr/bin/env python
# coding: utf-8

# Kody źródłowe do książki: Python. Uczenie maszynowe w przykładach
#  
# Rozdział 8.: Wyszukiwanie ukrytych tematów w grupach dyskusyjnych poprzez ich klastrowanie i modelowanie
#  
# Autor: Yuxi (Hayden) Liu (yuxi.liu.ece@gmail.com)

# # Klastrowanie danych z grup dyskusyjnych 

# ## Klastrowanie danych z grup dyskusyjnych metodą k-średnich

from sklearn.datasets import fetch_20newsgroups

categories = [
    'alt.atheism',
    'talk.religion.misc',
    'comp.graphics',
    'sci.space',
]

groups = fetch_20newsgroups(subset='all', categories=categories)

labels = groups.target
label_names = groups.target_names


from nltk.stem import WordNetLemmatizer
from nltk.corpus import names
all_names = set(names.words())
lemmatizer = WordNetLemmatizer()

def get_cleaned_data(groups, lemmatizer, remove_words):
    data_cleaned = []

    for doc in groups.data:
        doc = doc.lower()
        doc_cleaned = ' '.join(lemmatizer.lemmatize(word) for word in doc.split() if word.isalpha() and word not in remove_words)
        data_cleaned.append(doc_cleaned)
        
    return data_cleaned

data_cleaned = get_cleaned_data(groups, lemmatizer, all_names)


from sklearn.feature_extraction.text import CountVectorizer
count_vector = CountVectorizer(stop_words="english", max_features=None, max_df=0.5, min_df=2)
data_cv = count_vector.fit_transform(data_cleaned)


from sklearn.cluster import KMeans
k = 4
kmeans = KMeans(n_clusters=k, n_init='auto', random_state=42)

kmeans.fit(data_cv)


clusters = kmeans.labels_

from collections import Counter
print(Counter(clusters))


from sklearn.feature_extraction.text import TfidfVectorizer
tfidf_vector = TfidfVectorizer(stop_words='english', max_features=None, max_df=0.5, min_df=2)


data_tv = tfidf_vector.fit_transform(data_cleaned)
kmeans.fit(data_tv)
clusters = kmeans.labels_
print(Counter(clusters))


import numpy as np
cluster_label = {i: labels[np.where(clusters == i)] for i in range(k)}

terms = tfidf_vector.get_feature_names_out()
centroids = kmeans.cluster_centers_
for cluster, index_list in cluster_label.items():
    counter = Counter(cluster_label[cluster])
    print(f'Klaster {cluster}. Liczba próbek: {len(index_list)}')
    for label_index, count in sorted(counter.items(), key=lambda x: x[1], reverse=True):
        print(f'- { label_names[label_index]}, liczba próbek: { count }')
    print('10 najważniejszych termów:')
    for ind in centroids[cluster].argsort()[-10:]:
        print('%s ' % terms[ind], end="")
    print('\n')


# ## Opisywanie klastrów przy użyciu narzędzia ChatGPT

keywords = ' '.join(terms[ind] for ind in centroids[0].argsort()[-100:])  


print(keywords)


import openai


# api_key = '<Tu wstaw wsój klucz OpenAI API>'

client = OpenAI(api_key=api_key)

def get_completion(prompt, model="text-davinci-003"):
    messages = [{"role": "user", "content": prompt}]
    response = client.chat.completions.create(
        model=model,
        messages=messages,
        temperature=0
    )
    return response.choices[0].message.content


# response = get_completion(f"Zwięźle opisz wspólne zagadnienia związane z poniższymi słowami kluczowymi: {keywords}")
# print(response)


# # Odkrywanie ukrytych tematów grup dyskusyjnych

# ## Modelowanie tematyczne z wykorzystaniem nieujemnej faktoryzacji macierzy

from sklearn.decomposition import NMF

t = 20
nmf = NMF(n_components=t, random_state=42)


nmf.fit(data_cv)

print(nmf.components_)


terms_cv = count_vector.get_feature_names_out()
for topic_idx, topic in enumerate(nmf.components_):
        print("Temat nr {}:" .format(topic_idx))
        print(" ".join([terms_cv[i] for i in topic.argsort()[-10:]]))


# ## Modelowanie tematyczne z wykorzystaniem ukrytej alokacji Dirichleta

from sklearn.decomposition import LatentDirichletAllocation

t = 20
lda = LatentDirichletAllocation(n_components=t, learning_method='batch',random_state=42)


lda.fit(data_cv)

print(lda.components_)


for topic_idx, topic in enumerate(lda.components_):
        print("Temat nr {}:" .format(topic_idx))
        print(" ".join([terms_cv[i] for i in topic.argsort()[-10:]]))


data_cleaned = get_cleaned_data(groups_3, lemmatizer, all_names)


data_embedding = []

for doc in data_cleaned:
#     print(doc)
    doc_vector = np.mean([model[word] for word in doc.split() if word in model], axis=0)
    data_embedding.append(doc_vector)
 
        
data_tsne = tsne_model.fit_transform(np.array(data_embedding))
plt.scatter(data_tsne[:, 0], data_tsne[:, 1], c=groups_3.target)

plt.show()


# ---

# Czytelnicy mogą pominąć następną komórkę.

get_ipython().system('jupyter nbconvert --to python ch8_part2.ipynb --TemplateExporter.exclude_input_prompt=True')

