import numpy as np
import pandas as pd
n_rows = 100000
df = pd.read_csv("train", nrows=n_rows)

X = df.drop(['click', 'id', 'hour', 'device_id', 'device_ip'], axis=1).values
Y = df['click'].values

X_train = X
Y_train = Y

from sklearn.preprocessing import OneHotEncoder
enc = OneHotEncoder(handle_unknown='ignore')
X_train_enc = enc.fit_transform(X_train)

# Selekcja cech z wykorzystaniem lasu losowego

from sklearn.ensemble import RandomForestClassifier
random_forest = RandomForestClassifier(n_estimators=100, criterion='gini', min_samples_split=30, n_jobs=-1)
random_forest.fit(X_train_enc.toarray(), Y_train)

feature_imp = random_forest.feature_importances_
print(feature_imp)

# 10 najniższych ocen i odpowiadające im najmniej istotne cechy
feature_names = enc.get_feature_names()
print(np.sort(feature_imp)[:10])
bottom_10 = np.argsort(feature_imp)[:10]
print('10 najmniej istotnych cech:\n', feature_names[bottom_10])

# 10 najwyższych ocen i odpowiadające im najbardziej istotne cechy
print(np.sort(feature_imp)[-10:])
top_10 = np.argsort(feature_imp)[-10:]
print('10 najbardziej istotnych cech:\n', feature_names[top_10])