from sklearn import datasets
dataset = datasets.load_diabetes()
X, y = dataset.data, dataset.target
num_new = 30    # 30 ostatnich próbek tworzy nowy zbiór danych
X_train = X[:-num_new, :]
y_train = y[:-num_new]
X_new = X[-num_new:, :]
y_new = y[-num_new:]

# Wstępne przetworzenie danych
from sklearn.preprocessing import StandardScaler
scaler = StandardScaler()
scaler.fit(X_train)

# Zapisanie modelu normalizującego
import pickle
pickle.dump(scaler, open("scaler.p", "wb" ))

# Trening modelu regresyjnego
from sklearn.svm import SVR
X_scaled_train = scaler.transform(X_train)
regressor = SVR(C=20)
regressor.fit(X_scaled_train, y_train)

# Zapisanie modelu regresyjnego
pickle.dump(regressor, open("regressor.p", "wb"))

# Wdrożenie modelu
my_scaler = pickle.load(open("scaler.p", "rb" ))
my_regressor = pickle.load(open("regressor.p", "rb"))
X_scaled_new = my_scaler.transform(X_new)
predictions = my_regressor.predict(X_scaled_new)

# Monitorowanie
from sklearn.metrics import r2_score
print(f'Wskaźnik R^2 skuteczności modelu: {r2_score(y_new, predictions):.3f}')