import DBcm

db_details = "TreningiBD.sqlite3"

from zapytania import *


def get_swim_sessions():
    """Zwraca listę krotek unikatowych znaczników czasu sesji treningowych."""
    with DBcm.UseDatabase(db_details) as db:
        db.execute(SQL_SESSIONS)
        results = db.fetchall()
    return results


def get_session_swimmers(date):
    """Funkcja wymaga przekazania daty (w formacie RRRR-MM-DD), 
    a zwraca listę krotek zawierających imię pływaka i jego grupę 
    wiekową (przefiltrowane po dacie)."""
    with DBcm.UseDatabase(db_details) as db:
        db.execute(SQL_SWIMMERS_BY_SESSION, (date,))
        results = db.fetchall()
    return results


def get_swimmers_events(name, age, date):
    """Funkcja wymaga przekazania daty (w formacie RRRR-MM-DD), imienia 
    pływaka, jego wieku i zwraca listę krotek zawierających konkurencje 
    zarejestrowane dla danego pływaka na treningu o podanej dacie."""
    with DBcm.UseDatabase(db_details) as db:
        db.execute(
            SQL_SWIMMERS_EVENTS_BY_SESSION,
            (
                name,
                age,
                date,
            ),
        )
        results = db.fetchall()
    return results


def get_swimmers_times(name, age, distance, stroke, date):
    """Funkcja wymaga przekazania daty (w formacie RRRR-MM-DD), imienia 
    pływaka, jego wieku, dystansu i stylu, a zwraca listę krotek zawierających
    czasy uzyskane przez pływaka na treningu o podanej dacie dla kombinacji
    stylu i dystansu."""
    with DBcm.UseDatabase(db_details) as db:
        db.execute(
            SQL_CHART_DATA_BY_SWIMMER_EVENT_SESSION,
            (
                name,
                age,
                distance,
                stroke,
                date,
            ),
        )
        results = db.fetchall()
    return results
