import pyrg_pomocnicze

import json
import statistics


CONVERSIONS = {
    "kraul": "dowolnym",
    "grzbietowy": "grzbietowym",
    "klasyczny": "klasycznym",
    "motyl": "motylkowym",
    "zmienny": "zmiennym",
}
COURSES = ("Mężczyźni, basen 50m", "Kobiety, basen 50m", 
           "Mężczyźni, basen 25m", "Kobiety, basen 25m")

JSONDATA = "rekordy.json"


def get_worlds(distance, stroke):
    """Na podstawie dystansu oraz stylu, funkcja zwraca listę czterech
    rekordów świata dla danego dystansu i stylu."""
    with open(JSONDATA) as jf:
        records = json.load(jf)
    event = f"{distance[:-1]} m stylem {CONVERSIONS[stroke]}"
    return [records[course][event] for course in COURSES]


def perform_conversions(times):
    """Na podstawie listy czasów zapisanych jako łańcuchy znaków, funkcja zwraca 
    średni czas jako łańcuch znaków oraz odwróconą listę czasów i listę 
    przeskalowanych czasów zapisanych jako liczby zmiennoprzecinkowe."""
    converts = []
    for t in times:
        # Może brakować wartości minut, musimy się przed tym zabezpieczyć
        if ":" in t:
            minutes, rest = t.split(":")
            seconds, hundredths = rest.split(".")
        else:
            minutes = 0
            seconds, hundredths = t.split(".")
        converts.append(int(minutes) * 60 * 100 + int(seconds) * 100 + int(hundredths))
    average = statistics.mean(converts)
    mins_secs, hundredths = f"{(average / 100):.2f}".split(".")
    mins_secs = int(mins_secs)
    minutes = mins_secs // 60
    seconds = mins_secs - minutes * 60
    average = f"{minutes}:{seconds:0>2}.{hundredths}"
    converts.reverse()
    times.reverse()
    from_max = max(converts)
    scaled = [pyrg_pomocnicze.convert2range(n, 0, from_max, 0, 350) for n in converts]
    return average, times, scaled  # Wyniki zwracane jako krotka
