import time
import timeit
import text_example
import memory_profiler

if __name__ == "__main__":
    print "Zajęta pamięć RAM przy uruchamianiu: {:0.1f} MiB".format(memory_profiler.memory_usage()[0])
    # Ładowanie słów bezpośrednio do zbioru
    t1 = time.time()
    words_set = set(text_example.readers)
    t2 = time.time()
    print "Zużycie pamięci RAM po utworzeniu zbioru: {:0.1f} MiB. Czas trwania: {:0.1f} s.".format(memory_profiler.memory_usage()[0], t2 - t1)
    print "Zbiór zawiera {} słów.".format(len(words_set))

    assert u'Zwiebel' in words_set
    time_cost = sum(timeit.repeat(stmt="u'Zwiebel' in words_set",
                                  setup="from __main__ import words_set",
                                  number=1,
                                  repeat=10000))
    print "Łączny czas wyszukiwania słowa: {:0.4f} s".format(time_cost)
