"""Generator zbioru Julii bez opcjonalnego rysowania obrazów na bazie biblioteki PIL"""
import time
from PIL import Image
import array

# Obszar przestrzeni zespolonej do przeanalizowania
x1, x2, y1, y2 = -1.8, 1.8, -1.8, 1.8
c_real, c_imag = -0.62772, -.42193


def show_greyscale(output_raw, width, height, max_iterations):
    """Przekształcanie listy w tablicę, funkcja korzysta z biblioteki PIL"""
    # Przekształcanie danych wyjściowych w dane wejściowe zgodne z biblioteką PIL
    # Skalowanie do [0...255]
    max_iterations = float(max(output_raw))
    print max_iterations
    scale_factor = float(max_iterations)
    scaled = [int(o / scale_factor * 255) for o in output_raw]
    output = array.array('B', scaled)  # tablica liczb całkowitych bez znaku
    # Wyświetlanie przy użyciu biblioteki PIL
    im = Image.new("L", (width, width))
    # EXPLAIN RAW L 0 -1
    im.frombytes(output.tostring(), "raw", "L", 0, -1)
    im.show()


def show_false_greyscale(output_raw, width, height, max_iterations):
    """Przekształcanie listy w tablicę, funkcja korzysta z biblioteki PIL"""
    # Przekształcanie danych wyjściowych w dane wejściowe zgodne z biblioteką PIL
    # Sprawdzenie poprawności tablicy 1-wymiarowej i żądanej postaci 2-wymiarowej
    assert width * height == len(output_raw)
    # Przeskalowanie output_raw, aby znajdowało się w zakresie włącznym [0..255]
    max_value = float(max(output_raw))
    output_raw_limited = [int(float(o) / max_value * 255) for o in output_raw]
    # Utworzenie trochę bardziej wyszukanej mapy kolorów prezentującej ich zmiany ze
    # zwiększonym kontrastem (podziękowania dla Johna Montgomery'ego)
    output_rgb = (
        (o + (256 * o) + (256 ** 2) * o) * 16 for o in output_raw_limited)  # bardziej rozbudowane
    # Tablica liczb całkowitych bez znaku (wielkość zależy od używanej platformy)
    output_rgb = array.array('I', output_rgb)
    # Wyświetlanie przy użyciu biblioteki PIL
    im = Image.new("RGB", (width, height))
    # EXPLAIN RGBX L 0 -1
    im.frombytes(output_rgb.tostring(), "raw", "RGBX", 0, -1)
    im.show()


def timefn(fn):
    def measure_time(*args, **kwargs):
        t1 = time.time()
        result = fn(*args, **kwargs)
        t2 = time.time()
        print (fn.func_name + " took " + str(t2 - t1) + " seconds")
        return result
    return measure_time


@timefn
def calculate_z_serial_purepython(maxiter, zs, cs):
    """Obliczanie listy output przy użyciu reguły aktualizacji zbioru Julii"""
    output = [0] * len(zs)
    for i in range(len(zs)):
        n = 0
        z = zs[i]
        c = cs[i]
        while n < maxiter and abs(z) < 2:
            z = z * z + c
            n += 1
        output[i] = n
    return output


def calc_pure_python(draw_output, desired_width, max_iterations):
    """Tworzenie listy współrzędnych zespolonych (zs) i parametrów zespolonych (cs), budowanie zbioru Julii i wyświetlanie danych"""
    x_step = (float(x2 - x1) / float(desired_width))
    y_step = (float(y1 - y2) / float(desired_width))
    x = []
    y = []
    ycoord = y2
    while ycoord > y1:
        y.append(ycoord)
        ycoord += y_step
    xcoord = x1
    while xcoord < x2:
        x.append(xcoord)
        xcoord += x_step
    # Utwórz listę współrzędnych i warunek początkowy dla każdej komórki.
    # Zauważ, że warunek początkowy to stała, która z łatwością może zostać usunięta.
    # Stała służy do symulowania rzeczywistego scenariusza z kilkoma wejściami
    # przekazanymi przykładowej funkcji.
    zs = []
    cs = []
    for ycoord in y:
        for xcoord in x:
            zs.append(complex(xcoord, ycoord))
            cs.append(complex(c_real, c_imag))

    print "Długość dla x:", len(x)
    print "Łączna liczba elementów:", len(zs)
    start_time = time.time()
    output = calculate_z_serial_purepython(max_iterations, zs, cs)
    end_time = time.time()
    secs = end_time - start_time
    print "Działanie funkcji " + calculate_z_serial_purepython.func_name + " trwało", secs, "s"

    if draw_output:
        # Ustawianie szerokości i wysokości na liczby wygenerowanych pikseli, zamiast
        # wstępnie zaokrąglanej żądanej szerokości i wysokości.
        width = len(x)
        height = len(y)
        show_false_greyscale(output, width, height, max_iterations)
        #show_greyscale(output, width, height, max_iterations)

    validation_sum = sum(output)
    print "Łączna suma elementów (do sprawdzenia poprawności):", validation_sum


# Obliczanie zbioru Julii za pomocą czystego rozwiązania opartego na języku Python
# z wykorzystaniem wartości domyślnych rozsądnych dla laptopa.
calc_pure_python(draw_output=True, desired_width=1000, max_iterations=300)
