
import math
from random import (normalvariate, random)
from datetime import (date, datetime)
from itertools import (count, groupby, ifilter, imap, islice)


def read_data(filename):
    with open(filename) as fd:
        for line in fd:
            data = line.strip().split(',')
            yield map(int, data)


def read_fake_data(filename):
    for i in count():
        sigma = random() * 2
        yield (i, normalvariate(0, sigma))


def day_grouper(iterable):
    key = lambda timestamp_value: date.fromtimestamp(timestamp_value[0])
    return groupby(iterable, key)


def check_anomaly(xxx_todo_changeme):
    # Znajdowana jest średnia, odchylenie standardowe i wartość maksymalna dla dnia.
    # Użycie algorytmu jednoprzejściowego średniej/odchylenia standardowego pozwala jedynie
    # raz wczytać dane dla dnia.
    (day, day_data) = xxx_todo_changeme
    n = 0
    mean = 0
    M2 = 0
    max_value = None
    for timestamp, value in day_data:
        n += 1
        delta = value - mean
        mean = mean + delta / n
        M2 += delta * (value - mean)
        max_value = max(max_value, value)
    variance = M2 / (n - 1)
    standard_deviation = math.sqrt(variance)

    # W tym miejscu faktycznie sprawdzane jest, czy dane dla dnia wykazują nieprawidłowość.
    # Jeśli tak jest, zwracana jest wartość dnia. W przeciwnym razie zostanie zwrócona wartość False.
    if max_value > mean + 6 * standard_deviation:
        return day
    return False


def rolling_window_grouper(data, window_size):
    window = tuple(islice(data, 0, window_size))
    while True:
        current_datetime = datetime.fromtimestamp(window[0][0])
        yield (current_datetime, window)
        window = window[1:] + (data.next(),)


if __name__ == "__main__":
    print "Użycie funkcji day_grouper:"
    data = read_fake_data("fake_filename")
    data_day = day_grouper(data)
    anomalous_dates = ifilter(None, imap(check_anomaly, data_day))
    first_anomalous_date = anomalous_dates.next()
    print "Pierwsza data z nieprawidłowościami: ", first_anomalous_date
    next_10_dates = islice(anomalous_dates, 10)
    print "10 następnych dat z nieprawidłowościami: ", list(next_10_dates)

    print "Użycie funkcji rolling_window_grouper:"
    data = read_fake_data("fake_filename")
    data_day = rolling_window_grouper(data, window_size=86400)
    anomalous_dates = ifilter(None, imap(check_anomaly, data_day))
    first_anomalous_date = anomalous_dates.next()
    print "Pierwsza data z nieprawidłowościami: ", first_anomalous_date
    next_10_dates = islice(anomalous_dates, 10)
    print "10 następnych dat z nieprawidłowościami: ", list(next_10_dates)
