import time
import timeit
import itertools
import text_example
import memory_profiler
import datrie

if __name__ == "__main__":
    print "Zajęta pamięć RAM przy uruchamianiu: {:0.1f} MiB".format(memory_profiler.memory_usage()[0])
    # Unikaj budowania tymczasowej listy słów za pomocą kodu Python. Listę przechowuj bezpośrednio w
    # drzewie trie.
    t0 = time.time()
    chars = set()
    for word in text_example.readers:
        chars.update(word)
    trie = datrie.BaseTrie(chars)

    t1 = time.time()
    print "Utworzono drzewo trie ze słownikiem liczącym {} znaków w czasie: {:0.1f} s.".format(len(chars), t1 - t0)
    readers = text_example.read_words(text_example.SUMMARISED_FILE)
    for word in readers:
        trie[word] = 0
    t2 = time.time()
    print "Zużycie pamięci RAM po utworzeniu drzewa trie: {:0.1f} MiB. Czas trwania: {:0.1f} s.".format(memory_profiler.memory_usage()[0], t2 - t1)
    print "Drzewo trie zawiera {} słów.".format(len(trie))

    assert u'Zwiebel' in trie
    time_cost = sum(timeit.repeat(stmt="u'Zwiebel' in trie",
                                  setup="from __main__ import trie",
                                  number=1,
                                  repeat=10000))
    print "Łączny czas wyszukiwania słowa: {:0.4f} s".format(time_cost)
